/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

abstract class PhraseScorer
extends Scorer {
    protected byte[] norms;
    protected float value;
    PhrasePositions min;
    PhrasePositions max;
    private float freq;

    PhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postings, Similarity similarity, byte[] norms) {
        super(similarity, weight);
        this.norms = norms;
        this.value = weight.getValue();
        if (postings.length > 0) {
            this.max = this.min = new PhrasePositions(postings[0].postings, postings[0].position, 0);
            this.max.doc = -1;
            int i = 1;
            while (i < postings.length) {
                PhrasePositions pp;
                this.max.next = pp = new PhrasePositions(postings[i].postings, postings[i].position, i);
                this.max = pp;
                this.max.doc = -1;
                ++i;
            }
            this.max.next = this.min;
        }
    }

    @Override
    public int docID() {
        return this.max.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.max.doc);
    }

    private boolean advanceMin(int target) throws IOException {
        if (!this.min.skipTo(target)) {
            this.max.doc = Integer.MAX_VALUE;
            return false;
        }
        this.min = this.min.next;
        this.max = this.max.next;
        return true;
    }

    @Override
    public float score() throws IOException {
        float raw = this.getSimilarity().tf(this.freq) * this.value;
        return this.norms == null ? raw : raw * this.getSimilarity().decodeNormValue(this.norms[this.max.doc]);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int advance(int target) throws IOException {
        this.freq = 0.0f;
        if (!this.advanceMin(target)) {
            return 0x7FFFFFFF;
        }
        restart = false;
        ** GOTO lbl13
        {
            restart = false;
            if (!this.advanceMin(this.max.doc)) {
                return 0x7FFFFFFF;
            }
            do {
                if (this.min.doc < this.max.doc || restart) continue block0;
                this.freq = this.phraseFreq();
                restart = true;
lbl13:
                // 2 sources

            } while (this.freq == 0.0f);
        }
        return this.max.doc;
    }

    @Override
    public final float freq() {
        return this.freq;
    }

    abstract float phraseFreq() throws IOException;

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

