/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class NGramPhraseQuery
extends PhraseQuery {
    private final int n;

    public NGramPhraseQuery(int n) {
        this.n = n;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        int pos;
        if (this.getSlop() != 0) {
            return super.rewrite(reader);
        }
        if (this.n < 2 || this.getTerms().length < 3) {
            return super.rewrite(reader);
        }
        int[] positions = this.getPositions();
        Term[] terms = this.getTerms();
        int prevPosition = positions[0];
        int i = 1;
        while (i < positions.length) {
            pos = positions[i];
            if (prevPosition + 1 != pos) {
                return super.rewrite(reader);
            }
            prevPosition = pos;
            ++i;
        }
        PhraseQuery optimized = new PhraseQuery();
        pos = 0;
        int lastPos = terms.length - 1;
        int i2 = 0;
        while (i2 < terms.length) {
            if (pos % this.n == 0 || pos >= lastPos) {
                optimized.add(terms[i2], positions[i2]);
            }
            ++pos;
            ++i2;
        }
        return optimized;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NGramPhraseQuery)) {
            return false;
        }
        NGramPhraseQuery other = (NGramPhraseQuery)o;
        if (this.n != other.n) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.getSlop() ^ this.getTerms().hashCode() ^ this.getPositions().hashCode() ^ this.n;
    }
}

