/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldDocSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DummyConcurrentLock;
import org.apache.lucene.util.ReaderUtil;

@Deprecated
public class MultiSearcher
extends Searcher {
    private Searchable[] searchables;
    private int[] starts;
    private int maxDoc = 0;

    public MultiSearcher(Searchable ... searchables) throws IOException {
        this.searchables = searchables;
        this.starts = new int[searchables.length + 1];
        int i = 0;
        while (i < searchables.length) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += searchables[i].maxDoc();
            ++i;
        }
        this.starts[searchables.length] = this.maxDoc;
    }

    public Searchable[] getSearchables() {
        return this.searchables;
    }

    protected int[] getStarts() {
        return this.starts;
    }

    @Override
    public void close() throws IOException {
        int i = 0;
        while (i < this.searchables.length) {
            this.searchables[i].close();
            ++i;
        }
    }

    @Override
    public int docFreq(Term term) throws IOException {
        int docFreq = 0;
        int i = 0;
        while (i < this.searchables.length) {
            docFreq += this.searchables[i].docFreq(term);
            ++i;
        }
        return docFreq;
    }

    @Override
    public Document doc(int n) throws CorruptIndexException, IOException {
        int i = this.subSearcher(n);
        return this.searchables[i].doc(n - this.starts[i]);
    }

    @Override
    public Document doc(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        int i = this.subSearcher(n);
        return this.searchables[i].doc(n - this.starts[i], fieldSelector);
    }

    public int subSearcher(int n) {
        return ReaderUtil.subIndex(n, this.starts);
    }

    public int subDoc(int n) {
        return n - this.starts[this.subSearcher(n)];
    }

    @Override
    public int maxDoc() throws IOException {
        return this.maxDoc;
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        nDocs = Math.min(nDocs, this.maxDoc());
        HitQueue hq = new HitQueue(nDocs, false);
        int totalHits = 0;
        int i = 0;
        while (i < this.searchables.length) {
            TopDocs docs = new MultiSearcherCallableNoSort(DummyConcurrentLock.INSTANCE, this.searchables[i], weight, filter, nDocs, hq, i, this.starts).call();
            totalHits += docs.totalHits;
            ++i;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i2 = hq.size() - 1;
        while (i2 >= 0) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
            --i2;
        }
        float maxScore = totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
        n = Math.min(n, this.maxDoc());
        FieldDocSortedHitQueue hq = new FieldDocSortedHitQueue(n);
        int totalHits = 0;
        float maxScore = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.searchables.length) {
            TopFieldDocs docs = new MultiSearcherCallableWithSort(DummyConcurrentLock.INSTANCE, this.searchables[i], weight, filter, n, hq, sort, i, this.starts).call();
            totalHits += docs.totalHits;
            maxScore = Math.max(maxScore, docs.getMaxScore());
            ++i;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i2 = hq.size() - 1;
        while (i2 >= 0) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
            --i2;
        }
        return new TopFieldDocs(totalHits, scoreDocs, hq.getFields(), maxScore);
    }

    @Override
    public void search(Weight weight, Filter filter, final Collector collector) throws IOException {
        int i = 0;
        while (i < this.searchables.length) {
            final int start = this.starts[i];
            Collector hc = new Collector(){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    collector.setScorer(scorer);
                }

                @Override
                public void collect(int doc) throws IOException {
                    collector.collect(doc);
                }

                @Override
                public void setNextReader(IndexReader reader, int docBase) throws IOException {
                    collector.setNextReader(reader, start + docBase);
                }

                @Override
                public boolean acceptsDocsOutOfOrder() {
                    return collector.acceptsDocsOutOfOrder();
                }
            };
            this.searchables[i].search(weight, filter, hc);
            ++i;
        }
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        Query[] queries = new Query[this.searchables.length];
        int i = 0;
        while (i < this.searchables.length) {
            queries[i] = this.searchables[i].rewrite(original);
            ++i;
        }
        return queries[0].combine(queries);
    }

    @Override
    public Explanation explain(Weight weight, int doc) throws IOException {
        int i = this.subSearcher(doc);
        return this.searchables[i].explain(weight, doc - this.starts[i]);
    }

    @Override
    public Weight createNormalizedWeight(Query original) throws IOException {
        Query rewrittenQuery = this.rewrite(original);
        HashSet<Term> terms = new HashSet<Term>();
        rewrittenQuery.extractTerms(terms);
        Map<Term, Integer> dfMap = this.createDocFrequencyMap(terms);
        int numDocs = this.maxDoc();
        CachedDfSource cacheSim = new CachedDfSource(dfMap, numDocs, this.getSimilarity());
        return cacheSim.createNormalizedWeight(rewrittenQuery);
    }

    Map<Term, Integer> createDocFrequencyMap(Set<Term> terms) throws IOException {
        Term[] allTermsArray = terms.toArray(new Term[terms.size()]);
        int[] aggregatedDfs = new int[allTermsArray.length];
        Searchable[] searchableArray = this.searchables;
        int n = this.searchables.length;
        int n2 = 0;
        while (n2 < n) {
            Searchable searchable = searchableArray[n2];
            int[] dfs = searchable.docFreqs(allTermsArray);
            int j = 0;
            while (j < aggregatedDfs.length) {
                int n3 = j;
                aggregatedDfs[n3] = aggregatedDfs[n3] + dfs[j];
                ++j;
            }
            ++n2;
        }
        HashMap<Term, Integer> dfMap = new HashMap<Term, Integer>();
        int i = 0;
        while (i < allTermsArray.length) {
            dfMap.put(allTermsArray[i], aggregatedDfs[i]);
            ++i;
        }
        return dfMap;
    }

    private static class CachedDfSource
    extends Searcher {
        private final Map<Term, Integer> dfMap;
        private final int maxDoc;

        public CachedDfSource(Map<Term, Integer> dfMap, int maxDoc, Similarity similarity) {
            this.dfMap = dfMap;
            this.maxDoc = maxDoc;
            this.setSimilarity(similarity);
        }

        @Override
        public int docFreq(Term term) {
            int df;
            try {
                df = this.dfMap.get(term);
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("df for term " + term.text() + " not available");
            }
            return df;
        }

        @Override
        public int[] docFreqs(Term[] terms) {
            int[] result = new int[terms.length];
            int i = 0;
            while (i < terms.length) {
                result[i] = this.docFreq(terms[i]);
                ++i;
            }
            return result;
        }

        @Override
        public int maxDoc() {
            return this.maxDoc;
        }

        @Override
        public Query rewrite(Query query) {
            return query;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Document doc(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Document doc(int i, FieldSelector fieldSelector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Explanation explain(Weight weight, int doc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void search(Weight weight, Filter filter, Collector results) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TopDocs search(Weight weight, Filter filter, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) {
            throw new UnsupportedOperationException();
        }
    }

    static final class MultiSearcherCallableNoSort
    implements Callable<TopDocs> {
        private final Lock lock;
        private final Searchable searchable;
        private final Weight weight;
        private final Filter filter;
        private final int nDocs;
        private final int i;
        private final HitQueue hq;
        private final int[] starts;

        public MultiSearcherCallableNoSort(Lock lock, Searchable searchable, Weight weight, Filter filter, int nDocs, HitQueue hq, int i, int[] starts) {
            this.lock = lock;
            this.searchable = searchable;
            this.weight = weight;
            this.filter = filter;
            this.nDocs = nDocs;
            this.hq = hq;
            this.i = i;
            this.starts = starts;
        }

        @Override
        public TopDocs call() throws IOException {
            TopDocs docs = this.searchable.search(this.weight, this.filter, this.nDocs);
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            int j = 0;
            while (j < scoreDocs.length) {
                ScoreDoc scoreDoc = scoreDocs[j];
                scoreDoc.doc += this.starts[this.i];
                this.lock.lock();
                try {
                    if (scoreDoc == this.hq.insertWithOverflow(scoreDoc)) {
                        break;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                ++j;
            }
            return docs;
        }
    }

    static final class MultiSearcherCallableWithSort
    implements Callable<TopFieldDocs> {
        private final Lock lock;
        private final Searchable searchable;
        private final Weight weight;
        private final Filter filter;
        private final int nDocs;
        private final int i;
        private final FieldDocSortedHitQueue hq;
        private final int[] starts;
        private final Sort sort;

        public MultiSearcherCallableWithSort(Lock lock, Searchable searchable, Weight weight, Filter filter, int nDocs, FieldDocSortedHitQueue hq, Sort sort, int i, int[] starts) {
            this.lock = lock;
            this.searchable = searchable;
            this.weight = weight;
            this.filter = filter;
            this.nDocs = nDocs;
            this.hq = hq;
            this.i = i;
            this.starts = starts;
            this.sort = sort;
        }

        @Override
        public TopFieldDocs call() throws IOException {
            TopFieldDocs docs = this.searchable.search(this.weight, this.filter, this.nDocs, this.sort);
            int j = 0;
            while (j < docs.fields.length) {
                if (docs.fields[j].getType() == 1) {
                    int j2 = 0;
                    while (j2 < docs.scoreDocs.length) {
                        FieldDoc fd = (FieldDoc)docs.scoreDocs[j2];
                        fd.fields[j] = (Integer)fd.fields[j] + this.starts[this.i];
                        ++j2;
                    }
                    break;
                }
                ++j;
            }
            this.lock.lock();
            try {
                this.hq.setFields(docs.fields);
            }
            finally {
                this.lock.unlock();
            }
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            int j2 = 0;
            while (j2 < scoreDocs.length) {
                FieldDoc fieldDoc = (FieldDoc)scoreDocs[j2];
                fieldDoc.doc += this.starts[this.i];
                this.lock.lock();
                try {
                    if (fieldDoc == this.hq.insertWithOverflow(fieldDoc)) {
                        break;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                ++j2;
            }
            return docs;
        }
    }
}

