/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;

class ConjunctionScorer
extends Scorer {
    private final Scorer[] scorers;
    private final float coord;
    private int lastDoc = -1;

    public ConjunctionScorer(Weight weight, float coord, Collection<Scorer> scorers) throws IOException {
        this(weight, coord, scorers.toArray(new Scorer[scorers.size()]));
    }

    public ConjunctionScorer(Weight weight, float coord, Scorer ... scorers) throws IOException {
        super(weight);
        this.scorers = scorers;
        this.coord = coord;
        int i = 0;
        while (i < scorers.length) {
            if (scorers[i].nextDoc() == Integer.MAX_VALUE) {
                this.lastDoc = Integer.MAX_VALUE;
                return;
            }
            ++i;
        }
        ArrayUtil.mergeSort(scorers, new Comparator<Scorer>(){

            @Override
            public int compare(Scorer o1, Scorer o2) {
                return o1.docID() - o2.docID();
            }
        });
        if (this.doNext() == Integer.MAX_VALUE) {
            this.lastDoc = Integer.MAX_VALUE;
            return;
        }
        int end = scorers.length - 1;
        int max = end >> 1;
        int i2 = 0;
        while (i2 < max) {
            Scorer tmp = scorers[i2];
            int idx = end - i2 - 1;
            scorers[i2] = scorers[idx];
            scorers[idx] = tmp;
            ++i2;
        }
    }

    private int doNext() throws IOException {
        Scorer firstScorer;
        int first = 0;
        int doc = this.scorers[this.scorers.length - 1].docID();
        while ((firstScorer = this.scorers[first]).docID() < doc) {
            doc = firstScorer.advance(doc);
            int n = first = first == this.scorers.length - 1 ? 0 : first + 1;
        }
        return doc;
    }

    @Override
    public int advance(int target) throws IOException {
        if (this.lastDoc == Integer.MAX_VALUE) {
            return this.lastDoc;
        }
        if (this.scorers[this.scorers.length - 1].docID() < target) {
            this.scorers[this.scorers.length - 1].advance(target);
        }
        this.lastDoc = this.doNext();
        return this.lastDoc;
    }

    @Override
    public int docID() {
        return this.lastDoc;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.lastDoc == Integer.MAX_VALUE) {
            return this.lastDoc;
        }
        if (this.lastDoc == -1) {
            this.lastDoc = this.scorers[this.scorers.length - 1].docID();
            return this.lastDoc;
        }
        this.scorers[this.scorers.length - 1].nextDoc();
        this.lastDoc = this.doNext();
        return this.lastDoc;
    }

    @Override
    public float score() throws IOException {
        float sum = 0.0f;
        int i = 0;
        while (i < this.scorers.length) {
            sum += this.scorers[i].score();
            ++i;
        }
        return sum * this.coord;
    }
}

