/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.messages;

import java.util.Locale;
import org.apache.lucene.messages.Message;
import org.apache.lucene.messages.NLS;

public class MessageImpl
implements Message {
    private static final long serialVersionUID = -3077643314630884523L;
    private String key;
    private Object[] arguments = new Object[0];

    public MessageImpl(String key) {
        this.key = key;
    }

    public MessageImpl(String key, Object ... args) {
        this(key);
        this.arguments = args;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return NLS.getLocalizedMessage(this.getKey(), locale, this.getArguments());
    }

    public String toString() {
        Object[] args = this.getArguments();
        StringBuilder sb = new StringBuilder(this.getKey());
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                sb.append(i == 0 ? " " : ", ").append(args[i]);
                ++i;
            }
        }
        return sb.toString();
    }
}

