/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermVectorsTermsWriterPerField;
import org.apache.lucene.index.TermVectorsTermsWriterPerThread;
import org.apache.lucene.index.TermsHashConsumer;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerThread;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

final class TermVectorsTermsWriter
extends TermsHashConsumer {
    final DocumentsWriter docWriter;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    IndexOutput tvx;
    IndexOutput tvd;
    IndexOutput tvf;
    int lastDocID;
    boolean hasVectors;
    int allocCount;

    public TermVectorsTermsWriter(DocumentsWriter docWriter) {
        this.docWriter = docWriter;
    }

    @Override
    public TermsHashConsumerPerThread addThread(TermsHashPerThread termsHashPerThread) {
        return new TermVectorsTermsWriterPerThread(termsHashPerThread, this);
    }

    @Override
    synchronized void flush(Map<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> threadsAndFields, SegmentWriteState state) throws IOException {
        if (this.tvx != null) {
            this.fill(state.numDocs);
            IOUtils.close(this.tvx, this.tvf, this.tvd);
            this.tvf = null;
            this.tvd = null;
            this.tvx = null;
            assert (state.segmentName != null);
            String idxName = IndexFileNames.segmentFileName(state.segmentName, "tvx");
            if (4L + (long)state.numDocs * 16L != state.directory.fileLength(idxName)) {
                throw new RuntimeException("after flush: tvx size mismatch: " + state.numDocs + " docs vs " + state.directory.fileLength(idxName) + " length in bytes of " + idxName + " file exists?=" + state.directory.fileExists(idxName));
            }
            this.lastDocID = 0;
            state.hasVectors = this.hasVectors;
            this.hasVectors = false;
        }
        for (Map.Entry<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> entry : threadsAndFields.entrySet()) {
            for (TermsHashConsumerPerField field : entry.getValue()) {
                TermVectorsTermsWriterPerField perField = (TermVectorsTermsWriterPerField)field;
                perField.termsHashPerField.reset();
                perField.shrinkHash();
            }
            TermVectorsTermsWriterPerThread perThread = (TermVectorsTermsWriterPerThread)entry.getKey();
            perThread.termsHashPerThread.reset(true);
        }
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                assert (this.allocCount == 1 + this.docFreeList.length);
                this.docFreeList = new PerDoc[ArrayUtil.oversize(this.allocCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    void fill(int docID) throws IOException {
        if (this.lastDocID < docID) {
            long tvfPosition = this.tvf.getFilePointer();
            while (this.lastDocID < docID) {
                this.tvx.writeLong(this.tvd.getFilePointer());
                this.tvd.writeVInt(0);
                this.tvx.writeLong(tvfPosition);
                ++this.lastDocID;
            }
        }
    }

    synchronized void initTermVectorsWriter() throws IOException {
        if (this.tvx == null) {
            boolean success = false;
            try {
                this.hasVectors = true;
                this.tvx = this.docWriter.directory.createOutput(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvx"));
                this.tvd = this.docWriter.directory.createOutput(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvd"));
                this.tvf = this.docWriter.directory.createOutput(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvf"));
                this.tvx.writeInt(4);
                this.tvd.writeInt(4);
                this.tvf.writeInt(4);
                success = true;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.tvx, this.tvd, this.tvf);
                }
                throw throwable;
            }
            if (!success) {
                IOUtils.closeWhileHandlingException(this.tvx, this.tvd, this.tvf);
            }
            this.lastDocID = 0;
        }
    }

    synchronized void finishDocument(PerDoc perDoc) throws IOException {
        assert (this.docWriter.writer.testPoint("TermVectorsTermsWriter.finishDocument start"));
        this.initTermVectorsWriter();
        this.fill(perDoc.docID);
        this.tvx.writeLong(this.tvd.getFilePointer());
        this.tvx.writeLong(this.tvf.getFilePointer());
        this.tvd.writeVInt(perDoc.numVectorFields);
        if (perDoc.numVectorFields > 0) {
            int i = 0;
            while (i < perDoc.numVectorFields) {
                this.tvd.writeVInt(perDoc.fieldNumbers[i]);
                ++i;
            }
            assert (0L == perDoc.fieldPointers[0]);
            long lastPos = perDoc.fieldPointers[0];
            int i2 = 1;
            while (i2 < perDoc.numVectorFields) {
                long pos = perDoc.fieldPointers[i2];
                this.tvd.writeVLong(pos - lastPos);
                lastPos = pos;
                ++i2;
            }
            perDoc.perDocTvf.writeTo(this.tvf);
            perDoc.numVectorFields = 0;
        }
        assert (this.lastDocID == perDoc.docID) : "lastDocID=" + this.lastDocID + " perDoc.docID=" + perDoc.docID;
        ++this.lastDocID;
        perDoc.reset();
        this.free(perDoc);
        assert (this.docWriter.writer.testPoint("TermVectorsTermsWriter.finishDocument end"));
    }

    @Override
    public void abort() {
        this.hasVectors = false;
        try {
            IOUtils.closeWhileHandlingException(this.tvx, this.tvd, this.tvf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.docWriter.directory.deleteFile(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvx"));
        }
        catch (IOException iOException) {}
        try {
            this.docWriter.directory.deleteFile(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvd"));
        }
        catch (IOException iOException) {}
        try {
            this.docWriter.directory.deleteFile(IndexFileNames.segmentFileName(this.docWriter.getSegment(), "tvf"));
        }
        catch (IOException iOException) {}
        this.tvf = null;
        this.tvd = null;
        this.tvx = null;
        this.lastDocID = 0;
    }

    synchronized void free(PerDoc doc) {
        assert (this.freeCount < this.docFreeList.length);
        this.docFreeList[this.freeCount++] = doc;
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        final DocumentsWriter.PerDocBuffer buffer;
        RAMOutputStream perDocTvf;
        int numVectorFields;
        int[] fieldNumbers;
        long[] fieldPointers;

        PerDoc() {
            this.buffer = TermVectorsTermsWriter.this.docWriter.newPerDocBuffer();
            this.perDocTvf = new RAMOutputStream(this.buffer);
            this.fieldNumbers = new int[1];
            this.fieldPointers = new long[1];
        }

        void reset() {
            this.perDocTvf.reset();
            this.buffer.recycle();
            this.numVectorFields = 0;
        }

        @Override
        void abort() {
            this.reset();
            TermVectorsTermsWriter.this.free(this);
        }

        void addField(int fieldNumber) {
            if (this.numVectorFields == this.fieldNumbers.length) {
                this.fieldNumbers = ArrayUtil.grow(this.fieldNumbers);
            }
            if (this.numVectorFields == this.fieldPointers.length) {
                this.fieldPointers = ArrayUtil.grow(this.fieldPointers);
            }
            this.fieldNumbers[this.numVectorFields] = fieldNumber;
            this.fieldPointers[this.numVectorFields] = this.perDocTvf.getFilePointer();
            ++this.numVectorFields;
        }

        @Override
        public long sizeInBytes() {
            return this.buffer.getSizeInBytes();
        }

        @Override
        public void finish() throws IOException {
            TermVectorsTermsWriter.this.finishDocument(this);
        }
    }
}

