/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PayloadProcessorProvider;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;

final class SegmentMergeInfo {
    Term term;
    int base;
    int ord;
    TermEnum termEnum;
    IndexReader reader;
    int delCount;
    private TermPositions postings;
    private int[] docMap;
    PayloadProcessorProvider.DirPayloadProcessor dirPayloadProcessor;

    SegmentMergeInfo(int b, TermEnum te, IndexReader r) throws IOException {
        this.base = b;
        this.reader = r;
        this.termEnum = te;
        this.term = te.term();
    }

    int[] getDocMap() {
        if (this.docMap == null) {
            this.delCount = 0;
            if (this.reader.hasDeletions()) {
                int maxDoc = this.reader.maxDoc();
                this.docMap = new int[maxDoc];
                int j = 0;
                int i = 0;
                while (i < maxDoc) {
                    if (this.reader.isDeleted(i)) {
                        ++this.delCount;
                        this.docMap[i] = -1;
                    } else {
                        this.docMap[i] = j++;
                    }
                    ++i;
                }
            }
        }
        return this.docMap;
    }

    TermPositions getPositions() throws IOException {
        if (this.postings == null) {
            this.postings = this.reader.termPositions();
        }
        return this.postings;
    }

    final boolean next() throws IOException {
        if (this.termEnum.next()) {
            this.term = this.termEnum.term();
            return true;
        }
        this.term = null;
        return false;
    }

    final void close() throws IOException {
        try {
            this.termEnum.close();
        }
        finally {
            if (this.postings != null) {
                this.postings.close();
            }
        }
    }
}

