/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.InvertedDocEndConsumer;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumerPerThread;
import org.apache.lucene.index.NormsWriterPerField;
import org.apache.lucene.index.NormsWriterPerThread;
import org.apache.lucene.index.SegmentNorms;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.IOUtils;

final class NormsWriter
extends InvertedDocEndConsumer {
    private final byte defaultNorm = Similarity.getDefault().encodeNormValue(1.0f);
    private FieldInfos fieldInfos;

    NormsWriter() {
    }

    @Override
    public InvertedDocEndConsumerPerThread addThread(DocInverterPerThread docInverterPerThread) {
        return new NormsWriterPerThread(docInverterPerThread, this);
    }

    @Override
    public void abort() {
    }

    void files(Collection<String> files) {
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void flush(Map<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> threadsAndFields, SegmentWriteState state) throws IOException {
        byField = new HashMap<FieldInfo, ArrayList<NormsWriterPerField>>();
        for (Map.Entry<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> entry : threadsAndFields.entrySet()) {
            fields = entry.getValue();
            fieldsIt = fields.iterator();
            while (fieldsIt.hasNext()) {
                perField = (NormsWriterPerField)fieldsIt.next();
                if (perField.upto > 0) {
                    l = (ArrayList<NormsWriterPerField>)byField.get(perField.fieldInfo);
                    if (l == null) {
                        l = new ArrayList<NormsWriterPerField>();
                        byField.put(perField.fieldInfo, l);
                    }
                    l.add(perField);
                    continue;
                }
                fieldsIt.remove();
            }
        }
        normsFileName = IndexFileNames.segmentFileName(state.segmentName, "nrm");
        normsOut = state.directory.createOutput(normsFileName);
        success = false;
        try {
            normsOut.writeBytes(SegmentNorms.NORMS_HEADER, 0, SegmentNorms.NORMS_HEADER.length);
            numField = this.fieldInfos.size();
            normCount = 0;
            fieldNumber = 0;
            while (fieldNumber < numField) {
                block23: {
                    block22: {
                        fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
                        toMerge = (List)byField.get(fieldInfo);
                        upto = 0;
                        if (toMerge == null) break block22;
                        numFields = toMerge.size();
                        ++normCount;
                        fields = new NormsWriterPerField[numFields];
                        uptos = new int[numFields];
                        j = 0;
                        while (j < numFields) {
                            fields[j] = (NormsWriterPerField)toMerge.get(j);
                            ++j;
                        }
                        numLeft = numFields;
                        while (numLeft > 0) {
                            if (!NormsWriter.$assertionsDisabled && uptos[0] >= fields[0].docIDs.length) {
                                throw new AssertionError((Object)(" uptos[0]=" + uptos[0] + " len=" + fields[0].docIDs.length));
                            }
                            minLoc = 0;
                            minDocID = fields[0].docIDs[uptos[0]];
                            j = 1;
                            while (j < numLeft) {
                                docID = fields[j].docIDs[uptos[j]];
                                if (docID < minDocID) {
                                    minDocID = docID;
                                    minLoc = j;
                                }
                                ++j;
                            }
                            if (NormsWriter.$assertionsDisabled || minDocID < state.numDocs) ** GOTO lbl59
                            throw new AssertionError();
lbl-1000:
                            // 1 sources

                            {
                                normsOut.writeByte(this.defaultNorm);
                                ++upto;
lbl59:
                                // 2 sources

                                ** while (upto < minDocID)
                            }
lbl60:
                            // 1 sources

                            normsOut.writeByte(fields[minLoc].norms[uptos[minLoc]]);
                            v0 = minLoc;
                            uptos[v0] = uptos[v0] + 1;
                            ++upto;
                            if (uptos[minLoc] != fields[minLoc].upto) continue;
                            fields[minLoc].reset();
                            if (minLoc != numLeft - 1) {
                                fields[minLoc] = fields[numLeft - 1];
                                uptos[minLoc] = uptos[numLeft - 1];
                            }
                            --numLeft;
                        }
                        while (upto < state.numDocs) {
                            normsOut.writeByte(this.defaultNorm);
                            ++upto;
                        }
                        break block23;
                    }
                    if (fieldInfo.isIndexed && !fieldInfo.omitNorms) {
                        ++normCount;
                        while (upto < state.numDocs) {
                            normsOut.writeByte(this.defaultNorm);
                            ++upto;
                        }
                    }
                }
                if (!NormsWriter.$assertionsDisabled && (long)(4 + normCount * state.numDocs) != normsOut.getFilePointer()) {
                    throw new AssertionError((Object)(".nrm file size mismatch: expected=" + (4 + normCount * state.numDocs) + " actual=" + normsOut.getFilePointer()));
                }
                ++fieldNumber;
            }
            success = true;
        }
        catch (Throwable var21_25) {
            if (success) {
                IOUtils.close(new Closeable[]{normsOut});
            } else {
                IOUtils.closeWhileHandlingException(new Closeable[]{normsOut});
            }
            throw var21_25;
        }
        if (success) {
            IOUtils.close(new Closeable[]{normsOut});
        } else {
            IOUtils.closeWhileHandlingException(new Closeable[]{normsOut});
        }
    }
}

