/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import org.apache.lucene.index.IndexFileNames;

public class IndexFileNameFilter
implements FilenameFilter {
    private static IndexFileNameFilter singleton = new IndexFileNameFilter();
    private HashSet<String> extensions = new HashSet();
    private HashSet<String> extensionsInCFS;

    private IndexFileNameFilter() {
        String ext;
        String[] stringArray = IndexFileNames.INDEX_EXTENSIONS;
        int n = IndexFileNames.INDEX_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            ext = stringArray[n2];
            this.extensions.add(ext);
            ++n2;
        }
        this.extensionsInCFS = new HashSet();
        stringArray = IndexFileNames.INDEX_EXTENSIONS_IN_COMPOUND_FILE;
        n = IndexFileNames.INDEX_EXTENSIONS_IN_COMPOUND_FILE.length;
        n2 = 0;
        while (n2 < n) {
            ext = stringArray[n2];
            this.extensionsInCFS.add(ext);
            ++n2;
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String extension = name.substring(1 + i);
            if (this.extensions.contains(extension)) {
                return true;
            }
            if (extension.startsWith("f") && extension.matches("f\\d+")) {
                return true;
            }
            if (extension.startsWith("s") && extension.matches("s\\d+")) {
                return true;
            }
        } else {
            if (name.equals("deletable")) {
                return true;
            }
            if (name.startsWith("segments")) {
                return true;
            }
        }
        return false;
    }

    public boolean isCFSFile(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String extension = name.substring(1 + i);
            if (this.extensionsInCFS.contains(extension)) {
                return true;
            }
            if (extension.startsWith("f") && extension.matches("f\\d+")) {
                return true;
            }
        }
        return false;
    }

    public static IndexFileNameFilter getFilter() {
        return singleton;
    }
}

