/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.BufferedDeletes;
import org.apache.lucene.index.BufferedDeletesStream;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

class FrozenBufferedDeletes {
    static final int BYTES_PER_DEL_QUERY = RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4 + 24;
    final PrefixCodedTerms terms;
    int termCount;
    final Query[] queries;
    final int[] queryLimits;
    final int bytesUsed;
    final int numTermDeletes;
    final long gen;

    public FrozenBufferedDeletes(BufferedDeletes deletes, long gen) {
        Comparable[] termsArray = deletes.terms.keySet().toArray(new Term[deletes.terms.size()]);
        this.termCount = termsArray.length;
        ArrayUtil.mergeSort((Comparable[])termsArray);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        Comparable[] comparableArray = termsArray;
        int n = termsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Comparable term = comparableArray[n2];
            builder.add((Term)term);
            ++n2;
        }
        this.terms = builder.finish();
        this.queries = new Query[deletes.queries.size()];
        this.queryLimits = new int[deletes.queries.size()];
        int upto = 0;
        for (Map.Entry<Query, Integer> ent : deletes.queries.entrySet()) {
            this.queries[upto] = ent.getKey();
            this.queryLimits[upto] = ent.getValue();
            ++upto;
        }
        this.bytesUsed = (int)this.terms.getSizeInBytes() + this.queries.length * BYTES_PER_DEL_QUERY;
        this.numTermDeletes = deletes.numTermDeletes.get();
        this.gen = gen;
    }

    public Iterable<Term> termsIterable() {
        return new Iterable<Term>(){

            @Override
            public Iterator<Term> iterator() {
                return FrozenBufferedDeletes.this.terms.iterator();
            }
        };
    }

    public Iterable<BufferedDeletesStream.QueryAndLimit> queriesIterable() {
        return new Iterable<BufferedDeletesStream.QueryAndLimit>(){

            @Override
            public Iterator<BufferedDeletesStream.QueryAndLimit> iterator() {
                return new Iterator<BufferedDeletesStream.QueryAndLimit>(){
                    private int upto;

                    @Override
                    public boolean hasNext() {
                        return this.upto < (this).FrozenBufferedDeletes.this.queries.length;
                    }

                    @Override
                    public BufferedDeletesStream.QueryAndLimit next() {
                        BufferedDeletesStream.QueryAndLimit ret = new BufferedDeletesStream.QueryAndLimit((this).FrozenBufferedDeletes.this.queries[this.upto], (this).FrozenBufferedDeletes.this.queryLimits[this.upto]);
                        ++this.upto;
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        String s = "";
        if (this.numTermDeletes != 0) {
            s = String.valueOf(s) + " " + this.numTermDeletes + " deleted terms (unique count=" + this.termCount + ")";
        }
        if (this.queries.length != 0) {
            s = String.valueOf(s) + " " + this.queries.length + " deleted queries";
        }
        if (this.bytesUsed != 0) {
            s = String.valueOf(s) + " bytesUsed=" + this.bytesUsed;
        }
        return s;
    }

    boolean any() {
        return this.termCount > 0 || this.queries.length > 0;
    }
}

