/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FormatPostingsFieldsConsumer;
import org.apache.lucene.index.FormatPostingsFieldsWriter;
import org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.lucene.index.FreqProxTermsWriterPerThread;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermsHashConsumer;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashConsumerPerThread;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.TermsHashPerThread;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.UnicodeUtil;

final class FreqProxTermsWriter
extends TermsHashConsumer {
    private byte[] payloadBuffer;
    final UnicodeUtil.UTF8Result termsUTF8 = new UnicodeUtil.UTF8Result();

    FreqProxTermsWriter() {
    }

    @Override
    public TermsHashConsumerPerThread addThread(TermsHashPerThread perThread) {
        return new FreqProxTermsWriterPerThread(perThread);
    }

    private static int compareText(char[] text1, int pos1, char[] text2, int pos2) {
        char c1;
        do {
            char c2;
            if ((c1 = text1[pos1++]) == (c2 = text2[pos2++])) continue;
            if ('\uffff' == c2) {
                return 1;
            }
            if ('\uffff' == c1) {
                return -1;
            }
            return c1 - c2;
        } while ('\uffff' != c1);
        return 0;
    }

    @Override
    void abort() {
    }

    @Override
    public void flush(Map<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> threadsAndFields, SegmentWriteState state) throws IOException {
        ArrayList<FreqProxTermsWriterPerField> allFields = new ArrayList<FreqProxTermsWriterPerField>();
        for (Map.Entry<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> entry : threadsAndFields.entrySet()) {
            Collection<TermsHashConsumerPerField> fields = entry.getValue();
            for (TermsHashConsumerPerField termsHashConsumerPerField : fields) {
                FreqProxTermsWriterPerField perField = (FreqProxTermsWriterPerField)termsHashConsumerPerField;
                if (perField.termsHashPerField.numPostings <= 0) continue;
                allFields.add(perField);
            }
        }
        CollectionUtil.quickSort(allFields);
        int numAllFields = allFields.size();
        FormatPostingsFieldsWriter consumer = new FormatPostingsFieldsWriter(state, this.fieldInfos);
        try {
            int start = 0;
            while (start < numAllFields) {
                FieldInfo fieldInfo = ((FreqProxTermsWriterPerField)allFields.get((int)start)).fieldInfo;
                String fieldName = fieldInfo.name;
                int end = start + 1;
                while (end < numAllFields && ((FreqProxTermsWriterPerField)allFields.get((int)end)).fieldInfo.name.equals(fieldName)) {
                    ++end;
                }
                FreqProxTermsWriterPerField[] fields = new FreqProxTermsWriterPerField[end - start];
                int i = start;
                while (i < end) {
                    fields[i - start] = (FreqProxTermsWriterPerField)allFields.get(i);
                    if (fieldInfo.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                        fieldInfo.storePayloads |= fields[i - start].hasPayloads;
                    }
                    ++i;
                }
                this.appendPostings(fieldName, state, fields, consumer);
                i = 0;
                while (i < fields.length) {
                    TermsHashPerField perField = fields[i].termsHashPerField;
                    int numPostings = perField.numPostings;
                    perField.reset();
                    perField.shrinkHash(numPostings);
                    fields[i].reset();
                    ++i;
                }
                start = end;
            }
            for (Map.Entry entry : threadsAndFields.entrySet()) {
                FreqProxTermsWriterPerThread perThread = (FreqProxTermsWriterPerThread)entry.getKey();
                perThread.termsHashPerThread.reset(true);
            }
        }
        finally {
            ((FormatPostingsFieldsConsumer)consumer).finish();
        }
    }

    /*
     * Exception decompiling
     */
    void appendPostings(String fieldName, SegmentWriteState state, FreqProxTermsWriterPerField[] fields, FormatPostingsFieldsConsumer consumer) throws CorruptIndexException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

