/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import java.io.Serializable;
import java.nio.CharBuffer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class CharTermAttributeImpl
extends AttributeImpl
implements CharTermAttribute,
TermAttribute,
Cloneable,
Serializable {
    private static int MIN_BUFFER_SIZE = 10;
    private char[] termBuffer = new char[ArrayUtil.oversize(MIN_BUFFER_SIZE, 2)];
    private int termLength = 0;

    @Override
    @Deprecated
    public String term() {
        return new String(this.termBuffer, 0, this.termLength);
    }

    @Override
    public final void copyBuffer(char[] buffer, int offset, int length) {
        this.growTermBuffer(length);
        System.arraycopy(buffer, offset, this.termBuffer, 0, length);
        this.termLength = length;
    }

    @Override
    @Deprecated
    public void setTermBuffer(char[] buffer, int offset, int length) {
        this.copyBuffer(buffer, offset, length);
    }

    @Override
    @Deprecated
    public void setTermBuffer(String buffer) {
        int length = buffer.length();
        this.growTermBuffer(length);
        buffer.getChars(0, length, this.termBuffer, 0);
        this.termLength = length;
    }

    @Override
    @Deprecated
    public void setTermBuffer(String buffer, int offset, int length) {
        assert (offset <= buffer.length());
        assert (offset + length <= buffer.length());
        this.growTermBuffer(length);
        buffer.getChars(offset, offset + length, this.termBuffer, 0);
        this.termLength = length;
    }

    @Override
    public final char[] buffer() {
        return this.termBuffer;
    }

    @Override
    @Deprecated
    public char[] termBuffer() {
        return this.termBuffer;
    }

    @Override
    public final char[] resizeBuffer(int newSize) {
        if (this.termBuffer.length < newSize) {
            char[] newCharBuffer = new char[ArrayUtil.oversize(newSize, 2)];
            System.arraycopy(this.termBuffer, 0, newCharBuffer, 0, this.termBuffer.length);
            this.termBuffer = newCharBuffer;
        }
        return this.termBuffer;
    }

    @Override
    @Deprecated
    public char[] resizeTermBuffer(int newSize) {
        return this.resizeBuffer(newSize);
    }

    private void growTermBuffer(int newSize) {
        if (this.termBuffer.length < newSize) {
            this.termBuffer = new char[ArrayUtil.oversize(newSize, 2)];
        }
    }

    @Override
    @Deprecated
    public int termLength() {
        return this.termLength;
    }

    @Override
    public final CharTermAttribute setLength(int length) {
        if (length > this.termBuffer.length) {
            throw new IllegalArgumentException("length " + length + " exceeds the size of the termBuffer (" + this.termBuffer.length + ")");
        }
        this.termLength = length;
        return this;
    }

    @Override
    public final CharTermAttribute setEmpty() {
        this.termLength = 0;
        return this;
    }

    @Override
    @Deprecated
    public void setTermLength(int length) {
        this.setLength(length);
    }

    @Override
    public final int length() {
        return this.termLength;
    }

    @Override
    public final char charAt(int index) {
        if (index >= this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.termBuffer[index];
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        if (start > this.termLength || end > this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.termBuffer, start, end - start);
    }

    @Override
    public final CharTermAttribute append(CharSequence csq) {
        if (csq == null) {
            return this.appendNull();
        }
        return this.append(csq, 0, csq.length());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final CharTermAttribute append(CharSequence csq, int start, int end) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (csq == null) {
                                csq = "null";
                            }
                            len = end - start;
                            csqlen = csq.length();
                            if (len < 0 || start > csqlen || end > csqlen) {
                                throw new IndexOutOfBoundsException();
                            }
                            if (len == 0) {
                                return this;
                            }
                            this.resizeBuffer(this.termLength + len);
                            if (len <= 4) ** GOTO lbl39
                            if (!(csq instanceof String)) break block5;
                            ((String)csq).getChars(start, end, this.termBuffer, this.termLength);
                            break block6;
                        }
                        if (!(csq instanceof StringBuilder)) break block7;
                        ((StringBuilder)csq).getChars(start, end, this.termBuffer, this.termLength);
                        break block6;
                    }
                    if (!(csq instanceof CharTermAttribute)) break block8;
                    System.arraycopy(((CharTermAttribute)csq).buffer(), start, this.termBuffer, this.termLength, len);
                    break block6;
                }
                if (!(csq instanceof CharBuffer) || !((CharBuffer)csq).hasArray()) break block9;
                cb = (CharBuffer)csq;
                System.arraycopy(cb.array(), cb.arrayOffset() + cb.position() + start, this.termBuffer, this.termLength, len);
                break block6;
            }
            if (!(csq instanceof StringBuffer)) ** GOTO lbl33
            ((StringBuffer)csq).getChars(start, end, this.termBuffer, this.termLength);
            break block6;
lbl-1000:
            // 1 sources

            {
                this.termBuffer[this.termLength++] = csq.charAt(start++);
lbl33:
                // 2 sources

                ** while (start < end)
            }
lbl34:
            // 1 sources

            return this;
        }
        this.termLength += len;
        return this;
lbl-1000:
        // 1 sources

        {
            this.termBuffer[this.termLength++] = csq.charAt(start++);
lbl39:
            // 2 sources

            ** while (start < end)
        }
lbl40:
        // 1 sources

        return this;
    }

    @Override
    public final CharTermAttribute append(char c) {
        this.resizeBuffer((int)(this.termLength + 1))[this.termLength++] = c;
        return this;
    }

    @Override
    public final CharTermAttribute append(String s) {
        if (s == null) {
            return this.appendNull();
        }
        int len = s.length();
        s.getChars(0, len, this.resizeBuffer(this.termLength + len), this.termLength);
        this.termLength += len;
        return this;
    }

    @Override
    public final CharTermAttribute append(StringBuilder s) {
        if (s == null) {
            return this.appendNull();
        }
        int len = s.length();
        s.getChars(0, len, this.resizeBuffer(this.termLength + len), this.termLength);
        this.termLength += len;
        return this;
    }

    @Override
    public final CharTermAttribute append(CharTermAttribute ta) {
        if (ta == null) {
            return this.appendNull();
        }
        int len = ta.length();
        System.arraycopy(ta.buffer(), 0, this.resizeBuffer(this.termLength + len), this.termLength, len);
        this.termLength += len;
        return this;
    }

    private CharTermAttribute appendNull() {
        this.resizeBuffer(this.termLength + 4);
        this.termBuffer[this.termLength++] = 110;
        this.termBuffer[this.termLength++] = 117;
        this.termBuffer[this.termLength++] = 108;
        this.termBuffer[this.termLength++] = 108;
        return this;
    }

    public int hashCode() {
        int code = this.termLength;
        code = code * 31 + ArrayUtil.hashCode(this.termBuffer, 0, this.termLength);
        return code;
    }

    @Override
    public void clear() {
        this.termLength = 0;
    }

    @Override
    public Object clone() {
        CharTermAttributeImpl t = (CharTermAttributeImpl)super.clone();
        t.termBuffer = new char[this.termLength];
        System.arraycopy(this.termBuffer, 0, t.termBuffer, 0, this.termLength);
        return t;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CharTermAttributeImpl) {
            CharTermAttributeImpl o = (CharTermAttributeImpl)other;
            if (this.termLength != o.termLength) {
                return false;
            }
            int i = 0;
            while (i < this.termLength) {
                if (this.termBuffer[i] != o.termBuffer[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.termBuffer, 0, this.termLength);
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        reflector.reflect(CharTermAttribute.class, "term", this.toString());
    }

    @Override
    public void copyTo(AttributeImpl target) {
        if (target instanceof CharTermAttribute) {
            CharTermAttribute t = (CharTermAttribute)((Object)target);
            t.copyBuffer(this.termBuffer, 0, this.termLength);
        } else {
            TermAttribute t = (TermAttribute)((Object)target);
            t.setTermBuffer(this.termBuffer, 0, this.termLength);
        }
    }
}

