/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseTokenizer;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public final class StopAnalyzer
extends StopwordAnalyzerBase {
    public static final Set<?> ENGLISH_STOP_WORDS_SET;

    static {
        List<String> stopWords = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with");
        CharArraySet stopSet = new CharArraySet(Version.LUCENE_CURRENT, stopWords.size(), false);
        stopSet.addAll(stopWords);
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet(stopSet);
    }

    public StopAnalyzer(Version matchVersion) {
        this(matchVersion, ENGLISH_STOP_WORDS_SET);
    }

    public StopAnalyzer(Version matchVersion, Set<?> stopWords) {
        super(matchVersion, stopWords);
    }

    public StopAnalyzer(Version matchVersion, File stopwordsFile) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(IOUtils.getDecodingReader(stopwordsFile, IOUtils.CHARSET_UTF_8), matchVersion));
    }

    public StopAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(stopwords, matchVersion));
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        LowerCaseTokenizer source = new LowerCaseTokenizer(this.matchVersion, reader);
        return new ReusableAnalyzerBase.TokenStreamComponents(source, new StopFilter(this.matchVersion, (TokenStream)source, this.stopwords));
    }
}

