/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.TransientUnaryRead;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.Functions;
import org.simantics.structural2.StandardProceduralChildVariable;
import org.simantics.structural2.queries.ConnectionSet;
import org.simantics.structural2.variables.ResourceWithContext;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;
import org.simantics.utils.datastructures.Pair;

public class ConnectionBrowser {
    public static Collection<ResourceWithContext> findConnectedComponents(ReadGraph graph, Resource connection, Variable configuration) throws DatabaseException {
        ArrayList<ResourceWithContext> result = new ArrayList<ResourceWithContext>();
        THashSet visitedConnections = new THashSet();
        ConnectionBrowser.findConnectedComponents(graph, connection, configuration, result, (THashSet<Resource>)visitedConnections);
        return result;
    }

    private static void findConnectedComponents(ReadGraph graph, Resource connection, Variable configuration, ArrayList<ResourceWithContext> result, THashSet<Resource> visitedConnections) throws DatabaseException {
        if (visitedConnections.add((Object)connection)) {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Statement stat : graph.getStatements(connection, STR.Connects)) {
                Resource def;
                Resource component = stat.getObject();
                Resource relation = graph.getInverse(stat.getPredicate());
                Resource boundConnection = graph.getPossibleObject(relation, STR.IsBoundBy);
                Resource type = graph.getPossibleObject(component, L0.InstanceOf);
                Resource resource = def = type != null ? graph.getPossibleObject(type, STR.IsDefinedBy) : null;
                if (boundConnection != null && def != null) {
                    Variable newContext = configuration.browsePossible(graph, component);
                    Resource newComposite = ConnectionBrowser.getCompositeOfConnection(graph, boundConnection);
                    if (newContext == null || newComposite == null || (newContext = ConnectionBrowser.browse(graph, def, newContext, newComposite)) == null) continue;
                    ConnectionBrowser.findConnectedComponents(graph, boundConnection, newContext, result, visitedConnections);
                    continue;
                }
                Variable context = configuration.browsePossible(graph, component);
                if (context == null) continue;
                result.add(new ResourceWithContext(component, context));
            }
            for (Resource join : graph.getObjects(connection, STR.IsJoinedBy)) {
                for (Resource otherConnection : graph.getObjects(join, STR.Joins)) {
                    Variable sibling;
                    if (connection.equals(otherConnection)) continue;
                    Resource sourceComposite = ConnectionBrowser.getCompositeOfConnection(graph, connection);
                    Resource targetComposite = ConnectionBrowser.getCompositeOfConnection(graph, otherConnection);
                    if (sourceComposite == null || targetComposite == null || (sibling = ConnectionBrowser.browseSibling(graph, sourceComposite, configuration, targetComposite)) == null) continue;
                    ConnectionBrowser.findConnectedComponents(graph, otherConnection, sibling, result, visitedConnections);
                }
            }
            try {
                for (Resource relation : graph.getObjects(connection, STR.Binds)) {
                    Resource composite = ConnectionBrowser.getCompositeOfConnection(graph, connection);
                    if (composite == null) continue;
                    Variable curConfiguration = configuration;
                    while (!graph.hasStatement(composite, STR.Defines)) {
                        composite = graph.getSingleObject(composite, L0.PartOf);
                        curConfiguration = (Variable)curConfiguration.getPropertyValue(graph, "Parent");
                    }
                    Variable parent = (Variable)curConfiguration.getPropertyValue(graph, "Parent");
                    Resource component = (Resource)curConfiguration.getPropertyValue(graph, "Represents");
                    for (Resource c : graph.getObjects(component, relation)) {
                        ConnectionBrowser.findConnectedComponents(graph, c, parent, result, visitedConnections);
                    }
                }
            }
            catch (NoSingleResultException noSingleResultException) {
            }
            catch (MissingVariableException missingVariableException) {
            }
            catch (MissingVariableValueException missingVariableValueException) {
                // empty catch block
            }
        }
    }

    public static Collection<Variable> findConnectedConnectionPoints(ReadGraph graph, Resource connection, Variable configuration) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        THashSet visitedConnections = new THashSet();
        THashSet visitedCps = new THashSet();
        ConnectionBrowser.findConnectedConnectionPoints(graph, connection, configuration, result, (THashSet<Resource>)visitedConnections, (THashSet<Variable>)visitedCps);
        return result;
    }

    public static VariableConnectionPointDescriptor drill(ReadGraph graph, VariableConnectionPointDescriptor pair) throws DatabaseException {
        Variable cp = pair.variable;
        String[] interfaceDescription = pair.interfaceDescription;
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        if (interfaceDescription != null && interfaceDescription.length > 0) {
            Variable context = cp.getParent(graph);
            String cpName = cp.getName(graph);
            int i = 0;
            while (i < interfaceDescription.length) {
                Variable procedural;
                String childCpName = interfaceDescription[i];
                String path = interfaceDescription[i + 1];
                if (childCpName.equals(cpName) && (procedural = context.browse(graph, path)) != null) {
                    return ConnectionBrowser.makeDescriptor(graph, STR, procedural);
                }
                i += 2;
            }
        } else {
            return pair;
        }
        return null;
    }

    private static Variable resolve(ReadGraph graph, Variable base, Resource component) throws DatabaseException {
        Map map = (Map)graph.syncRequest((Read)new VariableChildren(graph, base), (AsyncProcedure)TransientCacheAsyncListener.instance());
        Variable result = (Variable)map.get(component);
        if (result != null) {
            return result;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(component, L0.PartOf);
        if (parent == null) {
            return null;
        }
        Variable v = ConnectionBrowser.resolve(graph, base, parent);
        if (v == null) {
            return null;
        }
        map = (Map)graph.syncRequest((Read)new VariableChildren(graph, v), (AsyncProcedure)TransientCacheAsyncListener.instance());
        return (Variable)map.get(component);
    }

    private static VariableConnectionPointDescriptor makeDescriptor(ReadGraph graph, StructuralResource2 STR, Variable variable) throws DatabaseException {
        Variable interfaceProperty = Functions.resolveInterface(graph, STR, variable.getParent(graph));
        String[] interfaceDescription = (String[])interfaceProperty.getValue(graph, (Binding)Bindings.STRING_ARRAY);
        String uri = variable.getURI(graph);
        return new VariableConnectionPointDescriptor(variable, uri, interfaceDescription);
    }

    public static Collection<VariableConnectionPointDescriptor> climb(ReadGraph graph, Variable child, Resource cp, String subPath) throws DatabaseException {
        Variable curConfiguration = child.getParent(graph);
        boolean isStructural = false;
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Variable interfaceProperty = Functions.resolveInterface(graph, STR, curConfiguration);
        String[] interfaceDescription = (String[])interfaceProperty.getValue(graph, (Binding)Bindings.STRING_ARRAY);
        if (interfaceDescription != null) {
            boolean bl = isStructural = interfaceDescription != Functions.BUILTIN_STRUCTURAL_CPS;
            if (interfaceDescription.length > 0) {
                if (subPath == null) {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    String cpName = (String)graph.getRelatedValue(cp, L0.HasName, (Binding)Bindings.STRING);
                    subPath = "#" + cpName;
                }
                String childName = child.getName(graph);
                String path = "/" + childName + subPath;
                int i = 0;
                while (i < interfaceDescription.length) {
                    if (path.equals(interfaceDescription[i + 1])) {
                        Resource cp2;
                        Collection<VariableConnectionPointDescriptor> res;
                        String parentCp = interfaceDescription[i];
                        Variable pConn = curConfiguration.getPossibleProperty(graph, parentCp);
                        if (pConn != null && (res = ConnectionBrowser.climb(graph, curConfiguration, cp2 = pConn.getPossiblePredicateResource(graph), path)) != null) {
                            return res;
                        }
                        return Collections.emptyList();
                    }
                    i += 2;
                }
            }
        }
        if (child instanceof StandardProceduralChildVariable) {
            Variable conn = child.getPossibleProperty(graph, cp);
            StandardProceduralChildVariable.FixedConnection fc = (StandardProceduralChildVariable.FixedConnection)conn.getValue(graph);
            ArrayList<VariableConnectionPointDescriptor> result = new ArrayList<VariableConnectionPointDescriptor>();
            result.add(ConnectionBrowser.makeDescriptor(graph, STR, conn));
            for (Pair<String, Resource> cpzz : fc.cps) {
                Variable component = curConfiguration.getChild(graph, (String)cpzz.first);
                Variable cp2 = component.getProperty(graph, (Resource)cpzz.second);
                result.add(ConnectionBrowser.makeDescriptor(graph, STR, cp2));
            }
            return result;
        }
        Resource res = cp;
        Resource represents = child.getRepresents(graph);
        if (isStructural) {
            Collection conns = graph.getObjects(represents, res);
            HashSet<VariableConnectionPointDescriptor> result = new HashSet<VariableConnectionPointDescriptor>();
            for (Resource c : conns) {
                Pair rs = (Pair)graph.syncRequest((Read)new ConnectionComponentsWithAncestor(graph, c), (AsyncProcedure)TransientCacheAsyncListener.instance());
                result.addAll((Collection)graph.syncRequest((Read)ConnectionVariables.forStructural(graph, curConfiguration, (Pair<Set<Resource>, Resource>)rs)));
            }
            return result;
        }
        Resource connection = graph.getPossibleObject(represents, res);
        if (connection != null) {
            Pair rs = (Pair)graph.syncRequest((Read)new ConnectionComponentsWithAncestor(graph, connection), (AsyncProcedure)TransientCacheAsyncListener.instance());
            return (Collection)graph.syncRequest((Read)ConnectionVariables.forConfiguration(graph, curConfiguration, (Pair<Set<Resource>, Resource>)rs));
        }
        Collection conns = graph.getObjects(represents, res);
        HashSet<VariableConnectionPointDescriptor> result = new HashSet<VariableConnectionPointDescriptor>();
        for (Resource c : conns) {
            Pair rs = (Pair)graph.syncRequest((Read)new ConnectionComponentsWithAncestor(graph, c), (AsyncProcedure)TransientCacheAsyncListener.instance());
            result.addAll((Collection)graph.syncRequest((Read)ConnectionVariables.forConfiguration(graph, curConfiguration, (Pair<Set<Resource>, Resource>)rs)));
        }
        return result;
    }

    private static void findConnectedConnectionPoints(ReadGraph graph, Resource connection, Variable configuration, ArrayList<Variable> result, THashSet<Resource> visitedConnections, THashSet<Variable> visitedCps) throws DatabaseException {
        if (visitedConnections.add((Object)connection)) {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Statement stat : graph.getStatements(connection, STR.Connects)) {
                String name;
                Variable cp;
                Resource component = stat.getObject();
                Resource relation = graph.getInverse(stat.getPredicate());
                Resource boundConnection = graph.getPossibleObject(relation, STR.IsBoundBy);
                Resource type = graph.getSingleObject(component, L0.InstanceOf);
                Resource def = graph.getPossibleObject(type, STR.IsDefinedBy);
                if (boundConnection != null && def != null) {
                    Variable newContext = configuration.browse(graph, component);
                    Resource newComposite = ConnectionBrowser.getCompositeOfConnection(graph, boundConnection);
                    if (newContext == null || newComposite == null || (newContext = ConnectionBrowser.browse(graph, def, newContext, newComposite)) == null) continue;
                    ConnectionBrowser.findConnectedConnectionPoints(graph, boundConnection, newContext, result, visitedConnections, visitedCps);
                    continue;
                }
                Variable context = configuration.browsePossible(graph, component);
                if (context == null || (cp = context.getPossibleProperty(graph, name = (String)graph.getRelatedValue(relation, L0.HasName, (Binding)Bindings.STRING))) == null) continue;
                String[] interfaceDescription = (String[])context.getPossiblePropertyValue(graph, STR.proceduralConnectionPointPath, (Binding)Bindings.STRING_ARRAY);
                if (interfaceDescription != null && interfaceDescription.length > 0) {
                    if (!visitedCps.add((Object)cp)) continue;
                    int i = 0;
                    while (i < interfaceDescription.length) {
                        Variable procedural;
                        String cpName = interfaceDescription[i];
                        String path = interfaceDescription[i + 1];
                        if (name.equals(cpName) && (procedural = context.browse(graph, path)) != null) {
                            result.add(procedural);
                        }
                        i += 2;
                    }
                    continue;
                }
                result.add(cp);
            }
            for (Resource join : graph.getObjects(connection, STR.IsJoinedBy)) {
                for (Resource otherConnection : graph.getObjects(join, STR.Joins)) {
                    if (connection.equals(otherConnection)) continue;
                    Resource sourceComposite = ConnectionBrowser.getCompositeOfConnection(graph, connection);
                    Resource targetComposite = ConnectionBrowser.getCompositeOfConnection(graph, otherConnection);
                    if (sourceComposite == null || targetComposite == null) continue;
                    ConnectionBrowser.findConnectedConnectionPoints(graph, otherConnection, ConnectionBrowser.browseSibling(graph, sourceComposite, configuration, targetComposite), result, visitedConnections, visitedCps);
                }
            }
            try {
                for (Resource relation : graph.getObjects(connection, STR.Binds)) {
                    Resource composite = ConnectionBrowser.getCompositeOfConnection(graph, connection);
                    if (composite == null) continue;
                    Variable curConfiguration = configuration;
                    while (!graph.hasStatement(composite, STR.Defines)) {
                        composite = graph.getSingleObject(composite, L0.PartOf);
                        curConfiguration = curConfiguration.getParent(graph);
                    }
                    Variable parent = curConfiguration.getParent(graph);
                    Resource component = curConfiguration.getPossibleRepresents(graph);
                    if (component != null) {
                        for (Resource c : graph.getObjects(component, relation)) {
                            ConnectionBrowser.findConnectedConnectionPoints(graph, c, parent, result, visitedConnections, visitedCps);
                        }
                        continue;
                    }
                    Statement stm = graph.getPossibleStatement(connection, STR.Connects);
                    if (stm == null) continue;
                    Resource child = stm.getObject();
                    Resource cp = graph.getInverse(stm.getPredicate());
                    String cpName = (String)graph.getRelatedValue(cp, L0.HasName, (Binding)Bindings.STRING);
                    String childName = (String)graph.getRelatedValue(child, L0.HasName, (Binding)Bindings.STRING);
                    Collection<Variable> up = ConnectionBrowser.climbInterface(graph, curConfiguration, childName, cpName, "#" + cpName);
                    if (up == null) continue;
                    result.addAll(up);
                }
            }
            catch (NoSingleResultException noSingleResultException) {
            }
            catch (MissingVariableException missingVariableException) {
            }
            catch (MissingVariableValueException missingVariableValueException) {
                // empty catch block
            }
        }
    }

    public static Collection<Variable> climbInterface(ReadGraph graph, Variable curConfiguration, String childName, String cp, String subPath) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Variable interfaceProperty = Functions.resolveInterface(graph, STR, curConfiguration);
        String[] interfaceDescription = (String[])interfaceProperty.getValue(graph, (Binding)Bindings.STRING_ARRAY);
        if (interfaceDescription == null || interfaceDescription.length == 0) {
            Variable child = curConfiguration.getChild(graph, childName);
            Variable conn = child.getProperty(graph, cp);
            if (child instanceof StandardProceduralChildVariable) {
                StandardProceduralChildVariable.FixedConnection fixedConnection = (StandardProceduralChildVariable.FixedConnection)conn.getValue(graph);
            } else {
                Resource res = conn.getPredicateResource(graph);
                Resource represents = child.getRepresents(graph);
                Resource connres = graph.getPossibleObject(represents, res);
                return ConnectionBrowser.findConnectedConnectionPoints(graph, connres, curConfiguration);
            }
        }
        String path = "/" + childName + subPath;
        int i = 0;
        while (i < interfaceDescription.length) {
            if (path.equals(interfaceDescription[i + 1])) {
                String parentCp = interfaceDescription[i];
                Collection<Variable> res = ConnectionBrowser.climbInterface(graph, curConfiguration.getParent(graph), curConfiguration.getName(graph), parentCp, path);
                if (res != null) {
                    return res;
                }
            }
            ++i;
        }
        return null;
    }

    public static Variable browse(ReadGraph graph, Resource root, Variable rootContext, Resource target) throws DatabaseException {
        if (target.equals(root)) {
            return rootContext;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(target, L0.HasName, (Binding)Bindings.STRING);
        Resource parent = graph.getPossibleObject(target, L0.PartOf);
        if (name == null || parent == null) {
            return null;
        }
        Variable parentVariable = ConnectionBrowser.browse(graph, root, rootContext, parent);
        if (parentVariable == null) {
            return null;
        }
        return parentVariable.getPossibleChild(graph, name);
    }

    public static Variable browseSibling(ReadGraph graph, Resource source, Variable sourceContext, Resource target) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        THashMap sourceMap = new THashMap();
        while (source != null && sourceContext != null) {
            sourceMap.put((Object)source, (Object)sourceContext);
            source = graph.getPossibleObject(source, L0.PartOf);
            sourceContext = (Variable)sourceContext.getPossiblePropertyValue(graph, "Parent");
        }
        return ConnectionBrowser.browseSibling(graph, (THashMap<Resource, Variable>)sourceMap, target);
    }

    private static Variable browseSibling(ReadGraph graph, THashMap<Resource, Variable> sourceMap, Resource target) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Variable result = (Variable)sourceMap.get((Object)target);
        if (result != null) {
            return result;
        }
        String name = (String)graph.getPossibleRelatedValue(target, L0.HasName, (Binding)Bindings.STRING);
        Resource parent = graph.getPossibleObject(target, L0.PartOf);
        if (name == null || parent == null) {
            return null;
        }
        Variable parentVariable = ConnectionBrowser.browseSibling(graph, sourceMap, parent);
        if (parentVariable == null) {
            return null;
        }
        return parentVariable.getPossibleChild(graph, name);
    }

    public static Resource getCompositeOfConnection(ReadGraph graph, Resource connection) throws DatabaseException {
        Resource diagramToComposite;
        Resource diagram;
        Resource diagramConnection;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        for (Resource component : graph.getObjects(connection, STR.Connects)) {
            Iterator iterator = graph.getObjects(component, L0.PartOf).iterator();
            if (!iterator.hasNext()) continue;
            Resource composite = (Resource)iterator.next();
            return composite;
        }
        Resource connToDiagramConn = graph.getPossibleResource("http://www.simantics.org/Modeling-1.2/ConnectionToDiagramConnection");
        if (connToDiagramConn != null && (diagramConnection = graph.getPossibleObject(connection, connToDiagramConn)) != null && (diagram = graph.getPossibleObject(diagramConnection, L0.PartOf)) != null && (diagramToComposite = graph.getPossibleResource("http://www.simantics.org/Modeling-1.2/DiagramToComposite")) != null) {
            return graph.getPossibleObject(diagram, diagramToComposite);
        }
        return null;
    }

    public static Collection<VariableConnectionPointDescriptor> flatten(ReadGraph graph, Variable child, Resource cp) throws DatabaseException {
        Collection<VariableConnectionPointDescriptor> climbed = ConnectionBrowser.climb(graph, child, cp, null);
        boolean needDrill = false;
        for (VariableConnectionPointDescriptor desc : climbed) {
            if (desc.interfaceDescription == null || desc.interfaceDescription.length <= 0) continue;
            needDrill = true;
            break;
        }
        if (!needDrill) {
            return climbed;
        }
        THashSet result = new THashSet();
        for (VariableConnectionPointDescriptor top : climbed) {
            VariableConnectionPointDescriptor drilled = ConnectionBrowser.drill(graph, top);
            if (drilled == null) continue;
            result.add((Object)drilled);
        }
        return result;
    }

    private static String safeURI(ReadGraph graph, Variable v) {
        if (v == null) {
            return "null variable";
        }
        try {
            return v.getURI(graph);
        }
        catch (DatabaseException e) {
            return v.toString();
        }
    }

    static class ChildMapOfVariable
    extends VariableRead<Map<Resource, Variable>> {
        public ChildMapOfVariable(Variable variable) {
            super(variable);
        }

        public Map<Resource, Variable> perform(ReadGraph graph) throws DatabaseException {
            HashMap<Resource, Variable> result = new HashMap<Resource, Variable>();
            for (Variable child : this.variable.getChildren(graph)) {
                Resource represents = child.getPossibleRepresents(graph);
                if (represents == null) continue;
                result.put(represents, child);
            }
            return result;
        }
    }

    public static class ConnectionComponentsWithAncestor
    extends TransientUnaryRead<Resource, Pair<Set<Resource>, Resource>> {
        private final Pair<Set<Resource>, Resource> result;

        public ConnectionComponentsWithAncestor(ReadGraph graph, Resource conn) throws DatabaseException {
            this(graph, conn, null);
        }

        public ConnectionComponentsWithAncestor(ReadGraph graph, Resource conn, Pair<Set<Resource>, Resource> result) throws DatabaseException {
            super(graph, (Object)conn);
            this.result = result;
        }

        private ConnectionSet connSet(ReadGraph graph, Resource r) throws DatabaseException {
            ConnectionSet cs = new ConnectionSet();
            cs.addConnection(graph, r);
            return cs;
        }

        public Pair<Set<Resource>, Resource> perform(ReadGraph graph, Resource resource) throws DatabaseException {
            if (this.result != null) {
                return this.result;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            CollectionSupport colls = (CollectionSupport)graph.getService(CollectionSupport.class);
            THashSet ancestorGenerators = new THashSet();
            Set parts = colls.createSet();
            ConnectionSet cs = this.connSet(graph, resource);
            for (Resource connRes : cs.getConnections()) {
                for (Statement stm : graph.getStatements(connRes, STR.Connects)) {
                    Resource component = stm.getObject();
                    Resource parent = graph.getPossibleObject(component, L0.PartOf);
                    if (parent == null) continue;
                    ancestorGenerators.add((Object)parent);
                }
                parts.add(connRes);
            }
            for (Resource join : cs.getJoins()) {
                parts.add(join);
                for (Resource composite : graph.getObjects(join, STR.JoinsComposite)) {
                    ancestorGenerators.add((Object)composite);
                }
            }
            Resource ancestor = ancestorGenerators.size() == 1 ? (Resource)ancestorGenerators.iterator().next() : CommonDBUtils.getNearestOwner((ReadGraph)graph, (Collection)ancestorGenerators);
            Pair result = Pair.make((Object)parts, (Object)ancestor);
            if (this.parameter != WITH_PARENT) {
                for (Resource r : (Set)result.first) {
                    if (r.equals(resource)) continue;
                    graph.syncRequest((Read)new ConnectionComponentsWithAncestor(graph, r, (Pair<Set<Resource>, Resource>)result), (AsyncProcedure)TransientCacheAsyncListener.instance());
                }
            }
            return result;
        }
    }

    public static class ConnectionVariables
    extends BinaryRead<Variable, Collection<Resource>, Collection<VariableConnectionPointDescriptor>> {
        private ConnectionVariables(Variable parameter1, Collection<Resource> parameter2) {
            super((Object)parameter1, parameter2);
        }

        public static ConnectionVariables forConfiguration(ReadGraph graph, Variable configuration, Pair<Set<Resource>, Resource> rs) throws DatabaseException {
            return new ConnectionVariables(ConnectionVariables.parent(graph, configuration, (Resource)rs.second), (Collection)rs.first);
        }

        public static ConnectionVariables forStructural(ReadGraph graph, Variable configuration, Pair<Set<Resource>, Resource> rs) throws DatabaseException {
            return new ConnectionVariables(configuration, (Collection)rs.first);
        }

        private static Variable parent(ReadGraph graph, Variable configuration, Resource ancestor) throws DatabaseException {
            Variable v = configuration;
            Resource represents = v.getRepresents(graph);
            while (!represents.equals(ancestor)) {
                if ((v = v.getParent(graph)) == null) {
                    throw new DatabaseException("parent representing ancestor not found for variable, configuration=" + ConnectionBrowser.safeURI(graph, configuration) + ", ancestor=" + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)ancestor));
                }
                represents = v.getRepresents(graph);
            }
            return v;
        }

        public Collection<VariableConnectionPointDescriptor> perform(ReadGraph graph) throws DatabaseException {
            if (this.parameter == null) {
                return Collections.emptyList();
            }
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            ArrayList<VariableConnectionPointDescriptor> result = new ArrayList<VariableConnectionPointDescriptor>();
            for (Resource connRes : (Collection)this.parameter2) {
                for (Statement stm : graph.getStatements(connRes, STR.Connects)) {
                    Variable cnp;
                    Resource component = stm.getObject();
                    Resource connectionPoint = graph.getInverse(stm.getPredicate());
                    Variable c = ConnectionBrowser.resolve(graph, (Variable)this.parameter, component);
                    if (c == null || (cnp = c.getPossibleProperty(graph, connectionPoint)) == null) continue;
                    result.add(ConnectionBrowser.makeDescriptor(graph, STR, cnp));
                }
            }
            return result;
        }
    }

    public static class JoinConnections
    extends ResourceRead<Collection<Resource>> {
        public JoinConnections(Resource join) {
            super(join);
        }

        public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
            ConnectionSet cs = new ConnectionSet();
            cs.addJoin(graph, this.resource);
            return cs.getConnections();
        }
    }

    public static final class VariableChildren
    extends TransientUnaryRead<Variable, Map<Resource, Variable>> {
        public VariableChildren(ReadGraph graph, Variable variable) throws DatabaseException {
            super(graph, (Object)variable);
        }

        public Map<Resource, Variable> perform(ReadGraph graph, Variable parameter) throws DatabaseException {
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            Map result = (Map)cs.createMap(Variable.class);
            for (Variable child : parameter.getChildren(graph)) {
                Resource represents = child.getPossibleRepresents(graph);
                if (represents == null) continue;
                result.put(represents, child);
            }
            return result;
        }
    }
}

