/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.scl;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.structural2.scl.ComponentTypeProperty;

public class ReadComponentTypeInterfaceRequest
extends ResourceRead<Map<String, ComponentTypeProperty>> {
    public static final THashMap<String, Type> typeMap = new THashMap();
    public static final THashMap<Type, Binding> bindingMap = new THashMap();
    public static final TCon ARRAY = Types.con((String)"Builtin", (String)"Array");
    private static final String DB_MODULE = "Simantics/DB";
    private static final String VARIABLES_MODULE = "Simantics/Variables";

    static {
        ReadComponentTypeInterfaceRequest.add((Type)Types.BOOLEAN, (Binding)Bindings.BOOLEAN);
        ReadComponentTypeInterfaceRequest.add((Type)Types.BYTE, (Binding)Bindings.BYTE);
        ReadComponentTypeInterfaceRequest.add((Type)Types.INTEGER, (Binding)Bindings.INTEGER);
        ReadComponentTypeInterfaceRequest.add((Type)Types.FLOAT, (Binding)Bindings.FLOAT);
        ReadComponentTypeInterfaceRequest.add((Type)Types.DOUBLE, (Binding)Bindings.DOUBLE);
        ReadComponentTypeInterfaceRequest.add((Type)Types.STRING, (Binding)Bindings.STRING);
        ReadComponentTypeInterfaceRequest.add((Type)Types.apply((Type)ARRAY, (Type)Types.STRING), (Binding)Bindings.STRING_ARRAY);
        ReadComponentTypeInterfaceRequest.add(Types.list((Type)Types.BOOLEAN), (Binding)new ArrayListBinding((Binding)Bindings.BOOLEAN));
        ReadComponentTypeInterfaceRequest.add(Types.list((Type)Types.BYTE), (Binding)new ArrayListBinding((Binding)Bindings.BYTE));
        ReadComponentTypeInterfaceRequest.add(Types.list((Type)Types.INTEGER), (Binding)new ArrayListBinding((Binding)Bindings.INTEGER));
        ReadComponentTypeInterfaceRequest.add(Types.list((Type)Types.FLOAT), (Binding)new ArrayListBinding((Binding)Bindings.FLOAT));
        ReadComponentTypeInterfaceRequest.add(Types.list((Type)Types.DOUBLE), (Binding)new ArrayListBinding((Binding)Bindings.DOUBLE));
        ReadComponentTypeInterfaceRequest.add(Types.list((Type)Types.STRING), (Binding)new ArrayListBinding((Binding)Bindings.STRING));
        ReadComponentTypeInterfaceRequest.add((Type)Types.con((String)DB_MODULE, (String)"Resource"), null);
        ReadComponentTypeInterfaceRequest.add((Type)Types.con((String)DB_MODULE, (String)"ReadGraphX"), null);
        ReadComponentTypeInterfaceRequest.add((Type)Types.con((String)VARIABLES_MODULE, (String)"Variable"), null);
    }

    private static void add(Type type, Binding binding) {
        typeMap.put((Object)type.toString(), (Object)type);
        bindingMap.put((Object)type, (Object)binding);
    }

    public ReadComponentTypeInterfaceRequest(Resource resource) {
        super(resource);
    }

    private void collect(ReadGraph graph, Resource t, THashMap<String, ComponentTypeProperty> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource relation : graph.getObjects(t, L0.DomainOf)) {
            Type type;
            if (!graph.isSubrelationOf(relation, L0.HasProperty)) continue;
            String name = (String)graph.getRelatedValue(relation, L0.HasName, (Binding)Bindings.STRING);
            String typeName = (String)graph.getPossibleRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING);
            if (typeName == null || (type = (Type)typeMap.get((Object)typeName)) == null) continue;
            ComponentTypeProperty property = new ComponentTypeProperty(relation, type);
            result.put((Object)name, (Object)property);
        }
    }

    public Map<String, ComponentTypeProperty> perform(ReadGraph graph) throws DatabaseException {
        THashMap result = new THashMap();
        this.collect(graph, this.resource, (THashMap<String, ComponentTypeProperty>)result);
        for (Resource t : graph.getSupertypes(this.resource)) {
            this.collect(graph, t, (THashMap<String, ComponentTypeProperty>)result);
        }
        return result;
    }
}

