/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.realization;

import java.util.Collection;
import java.util.Collections;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.RealizationType;
import org.simantics.db.common.request.RealizedChildSetRequest;
import org.simantics.db.layer0.adapter.Realization;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;

public class StructuralRealization
implements Realization {
    private static final Collection<Resource> EMPTY = Collections.emptyList();
    private static final Collection<NamedResource> EMPTY_VALUES = Collections.emptyList();
    protected final Resource resource;

    public StructuralRealization(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("null resource");
        }
        this.resource = resource;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuralRealization other = (StructuralRealization)obj;
        return this.resource.equals(other.resource);
    }

    public void forChildren(AsyncReadGraph graph, final AsyncProcedure<Collection<Resource>> procedure) {
        final StructuralResource2 sr = (StructuralResource2)graph.peekService(StructuralResource2.class);
        if (sr == null) {
            procedure.execute(graph, EMPTY);
            return;
        }
        graph.forPossibleType(this.resource, null, (AsyncProcedure)new AsyncProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                throwable.printStackTrace();
            }

            public void execute(AsyncReadGraph graph, Resource type) {
                if (type == null) {
                    procedure.execute(graph, (Object)EMPTY);
                } else {
                    graph.forPossibleObject(type, sr.IsDefinedBy, (AsyncProcedure)new AsyncProcedure<Resource>(){

                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                            throwable.printStackTrace();
                        }

                        public void execute(AsyncReadGraph graph, Resource definition) {
                            if (definition == null) {
                                procedure.execute(graph, (Object)EMPTY);
                            } else {
                                graph.asyncRequest((AsyncRead)new RealizedChildSetRequest(definition), procedure);
                            }
                        }
                    });
                }
            }
        });
    }

    public void forName(AsyncReadGraph graph, Resource resource, AsyncProcedure<String> procedure) {
        graph.forPossibleRelatedValue(resource, ((Layer0)graph.getService(Layer0.class)).HasName, (Binding)Bindings.STRING, procedure);
    }

    public void forType(AsyncReadGraph graph, Resource resource, AsyncProcedure<Resource> procedure) {
        graph.asyncRequest((AsyncRead)new RealizationType(resource, ((Layer0X)graph.getService(Layer0X.class)).Realization), procedure);
    }

    public void forValues(AsyncReadGraph graph, AsyncProcedure<Collection<NamedResource>> procedure) {
        procedure.execute(graph, EMPTY_VALUES);
    }

    public void forValue(AsyncReadGraph graph, Resource predicate, AsyncProcedure<Pair<Object, Binding>> procedure) {
        throw new Error("Not supported.");
    }
}

