/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.queries;

import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;

public class ConnectionSet {
    THashSet<Resource> connections = new THashSet();
    THashSet<Resource> joins = new THashSet();
    THashSet<Resource> excluded;
    THashSet<Resource> excludedJoins;

    public boolean excludeConnection(Resource connection) {
        if (this.excluded == null) {
            this.excluded = new THashSet();
        }
        return this.excluded.add((Object)connection);
    }

    public boolean excludeJoin(Resource join) {
        if (this.excludedJoins == null) {
            this.excludedJoins = new THashSet();
        }
        return this.excludedJoins.add((Object)join);
    }

    public boolean excludeConnections(Collection<Resource> connections) {
        if (connections.isEmpty()) {
            return false;
        }
        if (this.excluded == null) {
            this.excluded = new THashSet();
        }
        return this.excluded.addAll(connections);
    }

    public boolean isExcluded(Resource connection) {
        return this.excluded != null && this.excluded.contains((Object)connection);
    }

    public boolean isJoinExcluded(Resource join) {
        return this.excludedJoins != null && this.excludedJoins.contains((Object)join);
    }

    public void addConnection(ReadGraph g, Resource connection) throws DatabaseException {
        if (this.isExcluded(connection)) {
            return;
        }
        if (this.connections.add((Object)connection)) {
            StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
            for (Resource join : g.getObjects(connection, sr.IsJoinedBy)) {
                this.addJoin(g, join);
            }
        }
    }

    public void addJoin(ReadGraph g, Resource join) throws DatabaseException {
        if (this.isJoinExcluded(join)) {
            return;
        }
        if (this.joins.add((Object)join)) {
            StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
            for (Resource connection : g.getObjects(join, sr.Joins)) {
                this.addConnection(g, connection);
            }
        }
    }

    public Set<Resource> getConnections() {
        return this.connections;
    }

    public Set<Resource> getJoins() {
        return this.joins;
    }
}

