/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.genericrelations;

import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.genericrelations.StructuralChanges;

public class StructuralChangesWriter {
    ReadGraph g;
    Layer0 l0;
    StructuralResource2 sr;
    THashMap<Resource, ArrayList<StructuralChanges.Change>> changesByResource = new THashMap();

    public StructuralChangesWriter(ReadGraph g) {
        this.g = g;
        this.l0 = Layer0.getInstance((ReadGraph)g);
        this.sr = StructuralResource2.getInstance((ReadGraph)g);
    }

    private void addChange(Resource target, StructuralChanges.Change change) {
        ArrayList<StructuralChanges.Change> list = (ArrayList<StructuralChanges.Change>)this.changesByResource.get((Object)target);
        if (list == null) {
            list = new ArrayList<StructuralChanges.Change>(2);
            this.changesByResource.put((Object)target, list);
        }
        list.add(change);
    }

    public void addComponentModification(Resource component) throws DatabaseException {
        this.addChange(component, new StructuralChanges.ComponentModification(component));
    }

    public void addComponentTypeModification(Resource type) throws DatabaseException {
        this.addChange(type, new StructuralChanges.ComponentTypeModification(type));
    }

    public void addComponentAddition(Resource parent, Resource component) throws DatabaseException {
        this.addChange(parent, new StructuralChanges.ComponentAddition(component, parent));
    }

    public void addComponentRemoval(Resource parent, Resource component) throws DatabaseException {
        this.addChange(parent, new StructuralChanges.ComponentRemoval(component, parent));
    }

    public void addConnectionModification(Resource relatedComponent, Resource connection) throws DatabaseException {
        this.addChange(relatedComponent, new StructuralChanges.ConnectionChange(connection));
    }

    public StructuralChanges getResult() throws DatabaseException {
        THashMap result = new THashMap();
        for (Map.Entry entry : this.changesByResource.entrySet()) {
            Resource key = (Resource)entry.getKey();
            ArrayList changes = (ArrayList)entry.getValue();
            Resource model = (Resource)this.g.syncRequest((Read)new IndexRoot(key));
            if (model != null) {
                ArrayList modelChanges = (ArrayList)result.get((Object)model);
                if (modelChanges == null) {
                    modelChanges = new ArrayList();
                    result.put((Object)model, modelChanges);
                }
                modelChanges.addAll(changes);
                continue;
            }
            System.err.println("Didn't record a structural change, because model was not found! May cause synchronization errors.");
        }
        return new StructuralChanges((Map<Resource, ArrayList<StructuralChanges.Change>>)result);
    }
}

