/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.genericrelations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ChangeSet;
import org.simantics.db.Metadata;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.changeset.GenericChangeListener;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.TypeString;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.genericrelation.UnsupportedRelation;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.genericrelations.StructuralChanges;
import org.simantics.structural2.genericrelations.StructuralChangesWriter;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.ThreadUtils;

@Deprecated
public class ComponentsRelation
extends UnsupportedRelation
implements GenericRelationIndex {
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = true;
    public static final String ElementURI = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Diagram-0.0/Element");
    private static final Pair<String, Class<?>>[] fields = new Pair[]{Pair.make((Object)"Model", Resource.class), Pair.make((Object)"Composite", Resource.class), Pair.make((Object)"Component", Resource.class), Pair.make((Object)"Name", String.class), Pair.make((Object)"Types", String.class)};
    private final Resource resource;
    private final Resource primitiveType;
    private ConcurrentMap<Resource, ChangeListener> modelListeners = new ConcurrentHashMap<Resource, ChangeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentsRelation(ReadGraph graph, Resource resource, Resource primitiveType) {
        this.resource = resource;
        this.primitiveType = primitiveType;
        ComponentsRelation componentsRelation = this;
        synchronized (componentsRelation) {
            Session session = graph.getSession();
            ComponentsListenerStore store = (ComponentsListenerStore)session.peekService(ComponentsListenerStore.class);
            if (store == null) {
                session.registerService(ComponentsListenerStore.class, (Object)new ComponentsListenerStore());
            }
        }
    }

    public GenericRelation select(String bindingPattern, Object[] constants) {
        this.checkSelectionArguments(bindingPattern, constants, new String[]{"bffff"});
        final Resource subject = (Resource)constants[0];
        return new UnsupportedRelation(){

            public final List<Object[]> realize(ReadGraph graph) throws DatabaseException {
                Collection entries = (Collection)graph.syncRequest((Read)new Read<Collection<Entry>>(){

                    public Collection<Entry> perform(ReadGraph graph) throws DatabaseException {
                        return ComponentsRelation.this.doGetChildren(graph, subject);
                    }
                });
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                for (Entry entry : entries) {
                    result.add(new Object[]{entry.composite, entry.component, entry.name, entry.types});
                }
                return result;
            }
        };
    }

    public Collection<Entry> doGetChildren(ReadGraph graph, Resource model) {
        try {
            final StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
            final ConcurrentLinkedQueue<Entry> result = new ConcurrentLinkedQueue<Entry>();
            long time = System.nanoTime();
            final Resource composite = graph.getPossibleObject(model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
            if (composite != null) {
                graph.syncRequest((AsyncRead)new AsyncRead<Object>(){

                    public void perform(AsyncReadGraph graph, AsyncProcedure<Object> procedure) {
                        ComponentsRelation.this.walkComposite(graph, sr, composite, ComponentsRelation.this.primitiveType, result);
                        procedure.execute(graph, null);
                    }

                    public int getFlags() {
                        return 0;
                    }

                    public int threadHash() {
                        return this.hashCode();
                    }
                });
            }
            long time2 = System.nanoTime();
            System.out.println("Found " + result.size() + " components in " + 1.0E-6 * (double)(time2 - time) + "ms.");
            return result;
        }
        catch (DatabaseException e) {
            return Collections.emptyList();
        }
    }

    private void walkComposite(AsyncReadGraph graph, final StructuralResource2 sr, final Resource composite, final Resource primitiveType, final ConcurrentLinkedQueue<Entry> result) {
        final Layer0 l0 = (Layer0)graph.getService(Layer0.class);
        graph.forEachObject(composite, l0.ConsistsOf, (AsyncMultiProcedure)new AsyncMultiProcedureAdapter<Resource>(){

            private void recordResult(AsyncReadGraph graph, final Resource component, final String name, Set<Resource> types) {
                graph.asyncRequest((Read)new TypeString(l0, types), (AsyncListener)new TransientCacheAsyncListener<String>(){

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        t.printStackTrace();
                    }

                    public void execute(AsyncReadGraph graph, String types) {
                        result.add(new Entry(composite, component, name, types));
                    }
                });
            }

            public void execute(AsyncReadGraph graph, final Resource component) {
                graph.forTypes(component, (AsyncProcedure)new AsyncProcedureAdapter<Set<Resource>>(){

                    public void execute(AsyncReadGraph graph, final Set<Resource> types) {
                        if (types.contains(sr.Composite)) {
                            ComponentsRelation.this.walkComposite(graph, sr, component, primitiveType, result);
                        } else if (types.contains(sr.Component)) {
                            graph.forRelatedValue(component, l0.HasName, (Binding)Bindings.STRING, (AsyncProcedure)new AsyncProcedureAdapter<String>(){

                                public void execute(AsyncReadGraph graph, String name) {
                                    this.recordResult(graph, component, name, types);
                                }
                            });
                            if (!types.contains(primitiveType)) {
                                for (Resource type : types) {
                                    graph.forPossibleObject(type, sr.IsDefinedBy, (AsyncProcedure)new AsyncProcedureAdapter<Resource>(){

                                        public void execute(AsyncReadGraph graph, Resource composite) {
                                            if (composite == null) {
                                                return;
                                            }
                                            ComponentsRelation.this.walkComposite(graph, sr, composite, primitiveType, result);
                                        }
                                    });
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    public Pair<String, Class<?>>[] getFields() {
        return fields;
    }

    public void addListener(RequestProcessor processor, Resource model, Runnable observer) {
        ComponentsListenerStore store = (ComponentsListenerStore)processor.getSession().getService(ComponentsListenerStore.class);
        store.addListener(model, observer);
    }

    public void removeListener(RequestProcessor processor, Resource model, Runnable observer) {
        ComponentsListenerStore store = (ComponentsListenerStore)processor.getSession().getService(ComponentsListenerStore.class);
        store.removeListener(model, observer);
    }

    void fireListeners(RequestProcessor processor, Resource model) {
        ComponentsListenerStore store = (ComponentsListenerStore)processor.getSession().getService(ComponentsListenerStore.class);
        store.fireListeners(model);
    }

    public void reset(RequestProcessor processor, Resource input) {
        ComponentsListenerStore store = (ComponentsListenerStore)processor.getSession().getService(ComponentsListenerStore.class);
        System.out.println("ComponentsRelation reset: " + input);
        store.fireListeners(input);
    }

    public void untrack(RequestProcessor processor, Resource model) {
        ChangeListener listener = (ChangeListener)this.modelListeners.remove(model);
        if (listener != null) {
            GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)processor.getService(GraphChangeListenerSupport.class);
            changeSupport.removeMetadataListener(listener);
        }
    }

    public void trackAndIndex(RequestProcessor processor, final Resource model) {
        if (this.modelListeners.containsKey(model)) {
            return;
        }
        GraphChangeListenerSupport changeSupport = (GraphChangeListenerSupport)processor.getService(GraphChangeListenerSupport.class);
        GenericChangeListener<StructuralChangesRequest, StructuralChanges> listener = new GenericChangeListener<StructuralChangesRequest, StructuralChanges>(){

            public void onEvent(ReadGraph graph, MetadataI metadata, StructuralChanges event) throws DatabaseException {
                WriteGraph w = (WriteGraph)graph;
                w.addMetadata((Metadata)event);
                StructuralChanges.Change[] changes = event.get(model);
                if (changes == null) {
                    return;
                }
                final Session session = graph.getSession();
                final IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                final ArrayList<Object[]> additions = new ArrayList<Object[]>();
                final ArrayList<Resource> removals = new ArrayList<Resource>();
                final ArrayList<Resource> replacementKeys = new ArrayList<Resource>();
                final ArrayList<Object[]> replacementObjects = new ArrayList<Object[]>();
                StructuralChanges.Change[] changeArray = changes;
                int n = changes.length;
                int n2 = 0;
                while (n2 < n) {
                    String types;
                    String name;
                    StructuralChanges.Change entry;
                    StructuralChanges.Change _entry = changeArray[n2];
                    if (_entry instanceof StructuralChanges.ComponentAddition) {
                        entry = (StructuralChanges.ComponentAddition)_entry;
                        name = (String)graph.getPossibleRelatedValue(entry.component, L0.HasName, (Binding)Bindings.STRING);
                        types = (String)graph.syncRequest((Read)new TypeString(L0, graph.getTypes(entry.component)));
                        if (name != null && types != null) {
                            additions.add(new Object[]{graph.getPossibleObject(entry.component, L0.PartOf), entry.component, name, types});
                        }
                    } else if (_entry instanceof StructuralChanges.ComponentModification) {
                        entry = (StructuralChanges.ComponentModification)_entry;
                        name = (String)graph.getPossibleRelatedValue(((StructuralChanges.ComponentModification)entry).component, L0.HasName, (Binding)Bindings.STRING);
                        types = (String)graph.syncRequest((Read)new TypeString(L0, graph.getTypes(((StructuralChanges.ComponentModification)entry).component)));
                        if (name != null && types != null) {
                            replacementKeys.add(((StructuralChanges.ComponentModification)entry).component);
                            replacementObjects.add(new Object[]{graph.getPossibleObject(((StructuralChanges.ComponentModification)entry).component, L0.PartOf), ((StructuralChanges.ComponentModification)entry).component, name, types});
                        }
                    } else if (_entry instanceof StructuralChanges.ComponentRemoval) {
                        removals.add(((StructuralChanges.ComponentRemoval)_entry).component);
                    }
                    ++n2;
                }
                if (!(additions.isEmpty() && removals.isEmpty() && replacementKeys.isEmpty())) {
                    ThreadUtils.getBlockingWorkExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            boolean didChange = false;
                            if (!additions.isEmpty()) {
                                indexer.insert(null, (RequestProcessor)session, (GenericRelation)ComponentsRelation.this, ComponentsRelation.this.resource, model, additions);
                                didChange = true;
                            }
                            if (!removals.isEmpty()) {
                                indexer.remove(null, (RequestProcessor)session, (GenericRelation)ComponentsRelation.this, ComponentsRelation.this.resource, model, "Component", removals);
                                didChange = true;
                            }
                            if (!replacementKeys.isEmpty() && replacementKeys.size() == replacementObjects.size()) {
                                didChange |= indexer.replace(null, (RequestProcessor)session, (GenericRelation)ComponentsRelation.this, ComponentsRelation.this.resource, model, "Component", replacementKeys, replacementObjects);
                            }
                            if (didChange) {
                                ComponentsRelation.this.fireListeners((RequestProcessor)session, model);
                            }
                        }
                    });
                }
            }
        };
        changeSupport.addMetadataListener((ChangeListener)listener);
        this.modelListeners.put(model, (ChangeListener)listener);
    }

    public List<Map<String, Object>> query(RequestProcessor session, String search, String bindingPattern, Object[] constants, int maxResultCount) {
        if (!"bffff".equals(bindingPattern)) {
            throw new IllegalArgumentException("ComponentsRelation supports indexing only with 'bffff' binding pattern, received " + bindingPattern);
        }
        IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
        return indexer.query(null, search, session, this.resource, (Resource)constants[0], maxResultCount);
    }

    public List<Map<String, Object>> list(RequestProcessor session, String bindingPattern, Object[] constants, int maxResultCount) {
        if (!"bffff".equals(bindingPattern)) {
            throw new IllegalArgumentException("ComponentsRelation supports indexing only with 'bffff' binding pattern, received " + bindingPattern);
        }
        IndexedRelations indexer = (IndexedRelations)session.getService(IndexedRelations.class);
        return indexer.query(null, null, session, this.resource, (Resource)constants[0], maxResultCount);
    }

    static class ComponentsListenerStore {
        private final CopyOnWriteArrayList<Runnable> listeners = new CopyOnWriteArrayList();

        ComponentsListenerStore() {
        }

        public void addListener(Resource model, Runnable listener) {
            System.out.println("ComponentRelation.addListener(" + listener + "), " + this.listeners.size() + " total listeners");
            this.listeners.add(listener);
        }

        public void removeListener(Resource model, Runnable listener) {
            this.listeners.remove(listener);
            System.out.println("ComponentRelation.removeListener(" + listener + "), " + this.listeners.size() + " total listeners");
        }

        public void fireListeners(Resource model) {
            for (Runnable r : this.listeners) {
                r.run();
            }
        }
    }

    static class Entry {
        final Resource composite;
        final Resource component;
        final String name;
        final String types;

        Entry(Resource composite, Resource component, String name, String types) {
            this.composite = composite;
            this.component = component;
            this.name = name;
            this.types = types;
        }
    }

    public static class Model
    extends ResourceRead<Resource> {
        public Model(Resource composite) {
            super(composite);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
            Resource part = graph.getPossibleObject(this.resource, l0.PartOf);
            while (part != null) {
                if (graph.isInstanceOf(part, SIMU.Model)) {
                    return part;
                }
                part = graph.getPossibleObject(part, l0.PartOf);
            }
            return null;
        }
    }

    public static class StructuralChangesRequest
    extends UnaryRead<ChangeSet, StructuralChanges> {
        transient Resource element;
        private org.simantics.db.common.primitiverequest.Resource elementResourceRequest = new org.simantics.db.common.primitiverequest.Resource(ElementURI);

        public StructuralChangesRequest(ChangeSet parameter) {
            super((Object)parameter);
        }

        public StructuralChanges perform(ReadGraph graph) throws DatabaseException {
            StructuralChangesWriter w = new StructuralChangesWriter(graph);
            StructuralResource2 sr = w.sr;
            Layer0 l0 = w.l0;
            this.element = (Resource)graph.sync((ReadInterface)this.elementResourceRequest);
            block0: for (Resource value : ((ChangeSet)this.parameter).changedValues()) {
                Resource component;
                block13: {
                    component = graph.getPossibleObject(value, l0.PropertyOf);
                    do {
                        if (component == null) {
                            Resource assertion = graph.getPossibleObject(value, l0.HasObjectInverse);
                            if (assertion == null) continue block0;
                            Resource type = graph.getPossibleObject(assertion, l0.Asserts_Inverse);
                            w.addComponentTypeModification(type);
                            continue block0;
                        }
                        if (graph.isInstanceOf(component, sr.Component)) {
                            if (this.isElement(graph, component)) continue block0;
                            w.addComponentModification(component);
                            continue block0;
                        }
                        if (!graph.isInstanceOf(component, sr.SCLValue)) break block13;
                    } while ((component = graph.getPossibleObject(component, l0.PropertyOf)) != null);
                    continue;
                }
                if (!graph.isInstanceOf(component, sr.ComponentType)) continue;
                w.addComponentTypeModification(component);
            }
            for (ChangeSet.StatementChange change : ((ChangeSet)this.parameter).changedStatements()) {
                Resource subject = change.getSubject();
                Resource predicate = change.getPredicate();
                Resource object = change.getObject();
                if (predicate.equals(l0.PartOf)) {
                    if (!graph.isInstanceOf(object, sr.Composite)) continue;
                    if (change.isClaim()) {
                        if (!graph.isInstanceOf(subject, sr.Component)) continue;
                        w.addComponentAddition(object, subject);
                        continue;
                    }
                    w.addComponentRemoval(object, subject);
                    continue;
                }
                if (graph.isSubrelationOf(predicate, l0.PropertyOf)) {
                    if (!graph.isInstanceOf(object, sr.Component) || this.isElement(graph, object)) continue;
                    w.addComponentModification(object);
                    continue;
                }
                if (graph.isSubrelationOf(change.getPredicate(), sr.Connects)) {
                    if (!graph.isInstanceOf(object, sr.Component)) continue;
                    w.addConnectionModification(object, subject);
                    w.addComponentModification(object);
                    continue;
                }
                if (!sr.IsJoinedBy.equals(change.getPredicate())) continue;
                Resource relatedComponent = null;
                Iterator iterator = graph.getObjects(subject, sr.Connects).iterator();
                if (iterator.hasNext()) {
                    Resource component;
                    relatedComponent = component = (Resource)iterator.next();
                }
                if (relatedComponent == null && (iterator = graph.getObjects(object, sr.JoinsComposite).iterator()).hasNext()) {
                    Resource composite;
                    relatedComponent = composite = (Resource)iterator.next();
                }
                if (relatedComponent != null) {
                    w.addConnectionModification(relatedComponent, subject);
                    for (Resource connection : graph.getObjects(object, sr.Joins)) {
                        if (connection.equals(subject)) continue;
                        w.addConnectionModification(relatedComponent, connection);
                    }
                    continue;
                }
                System.err.println("Didn't record change " + subject.getResourceId() + " IsJoinedBy " + object.getResourceId() + " because didn't find any related resource.");
            }
            return w.getResult();
        }

        boolean isElement(ReadGraph graph, Resource r) throws DatabaseException {
            return this.element != null ? graph.isInstanceOf(r, this.element) : false;
        }
    }
}

