/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.OptionalBindingDefault;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.AbstractChildVariable;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.ValueAccessorWithBinding;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.IssueUtils;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.ConnectionComponents;
import org.simantics.structural2.ConnectionJoinComponents;
import org.simantics.structural2.StandardProceduralChildVariable;
import org.simantics.structural2.procedural.Component;
import org.simantics.structural2.procedural.ConnectionPoint;
import org.simantics.structural2.procedural.Interface;
import org.simantics.structural2.procedural.SubstructureElement;
import org.simantics.structural2.procedural.Terminal;
import org.simantics.structural2.queries.ConnectionPointMapOfResource;
import org.simantics.structural2.scl.CompileProceduralComponentType;
import org.simantics.structural2.scl.CompileSCLValueRequest;
import org.simantics.structural2.scl.CompiledExpression;
import org.simantics.structural2.scl.CompiledExpressionVariable;
import org.simantics.structural2.scl.VariableStructuralContext;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.ConnectionBrowser;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;
import org.simantics.utils.datastructures.MapList;

public class Functions {
    public static final Binding OPTIONAL_STRING = new OptionalBindingDefault((Binding)Bindings.STRING);
    @SCLValue(type="ValueAccessor")
    public static final ValueAccessor expressionValueAccessor = new ValueAccessorWithBinding(){

        public Binding getBinding() {
            return OPTIONAL_STRING;
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            if (value == null) {
                if (this.getValue((ReadGraph)graph, context) != null) {
                    this.clearExpression(graph, context);
                }
                return;
            }
            String expression = (String)value;
            Variable parent = context.getParent((ReadGraph)graph);
            if (!(parent instanceof AbstractPropertyVariable)) {
                return;
            }
            AbstractPropertyVariable property = (AbstractPropertyVariable)parent;
            Resource propertyResource = property.getRepresents((ReadGraph)graph);
            if (propertyResource == null) {
                return;
            }
            Resource container = property.getContainerResource((ReadGraph)graph);
            if (container == null) {
                return;
            }
            Resource predicate = (Resource)property.getPredicate((ReadGraph)graph).getPossiblePropertyValue((ReadGraph)graph, "Represents");
            if (predicate == null) {
                return;
            }
            Statement stat = graph.getPossibleStatement(container, predicate);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            boolean createNew = false;
            if (stat.isAsserted(container)) {
                createNew = true;
            } else if (!graph.isInstanceOf(propertyResource, STR.SCLValue)) {
                graph.deny(propertyResource);
                createNew = true;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (createNew) {
                propertyResource = graph.newResource();
                graph.claim(container, predicate, propertyResource);
                graph.claim(propertyResource, L0.InstanceOf, STR.SCLValue);
            }
            graph.claimLiteral(propertyResource, L0.SCLValue_expression, (Object)expression, (Binding)Bindings.STRING);
        }

        private void clearExpression(WriteGraph graph, Variable context) throws DatabaseException {
            Variable parent = context.getParent((ReadGraph)graph);
            if (!(parent instanceof AbstractPropertyVariable)) {
                return;
            }
            AbstractPropertyVariable property = (AbstractPropertyVariable)parent;
            Resource container = property.getContainerResource((ReadGraph)graph);
            if (container == null) {
                return;
            }
            Resource predicate = (Resource)property.getPredicate((ReadGraph)graph).getPossiblePropertyValue((ReadGraph)graph, "Represents");
            if (predicate == null) {
                return;
            }
            graph.deny(container, predicate);
        }

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            Variable parent = context.getParent(graph);
            if (!(parent instanceof AbstractPropertyVariable)) {
                return null;
            }
            AbstractPropertyVariable property = (AbstractPropertyVariable)parent;
            Resource propertyResource = property.getPossibleRepresents(graph);
            if (propertyResource == null) {
                return null;
            }
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(propertyResource, STR.SCLValue)) {
                return null;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            return graph.getPossibleRelatedValue(propertyResource, L0.SCLValue_expression);
        }
    };
    @SCLValue(type="ValueAccessor")
    public static final ValueAccessor connectionValueAccessor = new ValueAccessor(){

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            return this.getValue(graph, context);
        }

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            return new ConnectionImpl(variable.parent, variable.property);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap structuralChildDomainProperties = new VariableMapImpl(){

        public Variable getPossibleConnectionPointFromContext(ReadGraph graph, Variable variable, Resource context, String name) throws DatabaseException {
            Map connectionPoints = (Map)graph.syncRequest((Read)new ConnectionPointMapOfResource(graph, context), (AsyncProcedure)TransientCacheAsyncListener.instance());
            Resource cp = (Resource)connectionPoints.get(name);
            if (cp == null) {
                return null;
            }
            return new StandardGraphPropertyVariable(graph, variable, cp);
        }

        public Map<String, Variable> collectConnectionPointsFromContext(ReadGraph graph, Variable variable, Resource context, Map<String, Variable> map, boolean needSynchronized) throws DatabaseException {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Map cps = (Map)graph.syncRequest((Read)new ConnectionPointMapOfResource(graph, context), (AsyncProcedure)TransientCacheAsyncListener.instance());
            if (cps.size() == 0) {
                return map;
            }
            if (map == null) {
                map = new HashMap<String, Variable>(cps.size());
            }
            for (Map.Entry entry : cps.entrySet()) {
                String name = (String)entry.getKey();
                Resource cp = (Resource)entry.getValue();
                if (needSynchronized && !graph.isInstanceOf(cp, STR.SynchronizedConnectionRelation)) continue;
                map.put(name, (Variable)new StandardGraphPropertyVariable(graph, variable, cp));
            }
            return map;
        }

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            if ("proceduralConnectionPointPath".equals(name)) {
                return Functions.resolveInterface(graph, StructuralResource2.getInstance((ReadGraph)graph), context);
            }
            StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
            Variable cp = this.getPossibleConnectionPointFromContext(graph, (Variable)variable, variable.resource, name);
            if (cp != null) {
                return cp;
            }
            return All.getStandardChildDomainPropertyVariable((ReadGraph)graph, (Variable)context, (String)name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
            map = this.collectConnectionPointsFromContext(graph, (Variable)variable, variable.resource, map, false);
            Variable pcpp = Functions.resolveInterface(graph, StructuralResource2.getInstance((ReadGraph)graph), context);
            if (pcpp != null) {
                if (map == null) {
                    map = new HashMap<String, Variable>();
                }
                map.put("proceduralConnectionPointPath", pcpp);
            }
            return All.getStandardChildDomainPropertyVariables((ReadGraph)graph, (Variable)context, map);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, String classification, Map<String, Variable> map) throws DatabaseException {
            if ("http://www.simantics.org/Structural-1.2/SynchronizedRelation".equals(classification)) {
                return All.getStandardChildDomainPropertyVariables((ReadGraph)graph, (Variable)context, (String)classification, map);
            }
            if ("http://www.simantics.org/Structural-1.2/SynchronizedConnectionRelation".equals(classification)) {
                StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
                return this.collectConnectionPointsFromContext(graph, (Variable)variable, variable.resource, map, true);
            }
            if ("http://www.simantics.org/Structural-1.2/ConnectionRelation".equals(classification)) {
                StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
                return this.collectConnectionPointsFromContext(graph, (Variable)variable, variable.resource, map, false);
            }
            return super.getVariables(graph, context, classification, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap structuralChildDomainChildren = new VariableMapImpl(){

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            Map children;
            Resource represents;
            Resource type = context.getPossibleType(graph);
            if (type != null) {
                Map map;
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(type, STR.ProceduralComponentType) && (map = (Map)graph.syncRequest((Read)new ProceduralSubstructureRequest(context), (Listener)TransientCacheListener.instance())) != null) {
                    return (Variable)map.get(name);
                }
            }
            if ((represents = context.getPossibleRepresents(graph)) == null) {
                children = (Map)graph.syncRequest((Read)new StructuralChildMapOfResourceT(type));
                Resource child = (Resource)children.get(name);
                return All.getStandardChildDomainChildVariable((ReadGraph)graph, (Variable)context, (Resource)child, (String)name);
            }
            children = (Map)graph.syncRequest((Read)new StructuralChildMapOfResource(represents));
            Resource child = (Resource)children.get(name);
            return All.getStandardChildDomainChildVariable((ReadGraph)graph, (Variable)context, (Resource)child, (String)name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            Map children;
            Resource represents;
            Resource type = context.getPossibleType(graph);
            if (type != null) {
                Map mapPrime;
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(type, STR.ProceduralComponentType) && (mapPrime = (Map)graph.syncRequest((Read)new ProceduralSubstructureRequest(context), (Listener)TransientCacheListener.instance())) != null) {
                    if (map != null) {
                        map.putAll(mapPrime);
                        return map;
                    }
                    return mapPrime;
                }
            }
            if ((represents = context.getPossibleRepresents(graph)) == null) {
                children = (Map)graph.syncRequest((Read)new StructuralChildMapOfResourceT(type));
                return All.getStandardChildDomainChildVariables((ReadGraph)graph, (Variable)context, (Map)children, map);
            }
            children = (Map)graph.syncRequest((Read)new StructuralChildMapOfResource(represents));
            return All.getStandardChildDomainChildVariables((ReadGraph)graph, (Variable)context, (Map)children, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap structuralRunDomainChildren = new VariableMapImpl(){

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            Map children = (Map)graph.syncRequest((Read)new StructuralRunChildMapOfResource(context.getRepresents(graph)));
            Resource child = (Resource)children.get(name);
            return All.getStandardChildDomainChildVariable((ReadGraph)graph, (Variable)context, (Resource)child, (String)name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
            Map children = (Map)graph.syncRequest((Read)new StructuralRunChildMapOfResource(variable.resource));
            return All.getStandardChildDomainChildVariables((ReadGraph)graph, (Variable)context, (Map)children, map);
        }
    };
    public static final String[] BUILTIN_STRUCTURAL_CPS = new String[0];

    public static List<SubstructureElement> getProceduralDesc(ReadGraph graph, Variable context) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = context.getPossibleType(graph);
        if (type != null && graph.isInstanceOf(type, STR.ProceduralComponentType)) {
            return (List)graph.syncRequest((Read)new SubstructureRequest(context));
        }
        return null;
    }

    public static Map<String, Variable> getProcedural(ReadGraph graph, Variable context, List<SubstructureElement> elements, Map<String, Variable> map) throws DatabaseException {
        if (map == null) {
            map = new HashMap<String, Variable>();
        }
        MapList conns = new MapList();
        for (SubstructureElement sub : elements) {
            if (!(sub instanceof org.simantics.structural2.procedural.Connection)) continue;
            org.simantics.structural2.procedural.Connection conn = (org.simantics.structural2.procedural.Connection)sub;
            for (ConnectionPoint connectionPoint : conn.connectionPoints) {
                if (!(connectionPoint instanceof Terminal)) continue;
                Terminal t = (Terminal)connectionPoint;
                conns.add((Object)t.component, (Object)conn);
            }
        }
        HashMap<String, Component> proceduralChildren = new HashMap<String, Component>();
        for (SubstructureElement sub : elements) {
            if (!(sub instanceof Component)) continue;
            Component component = (Component)sub;
            proceduralChildren.put(component.name, component);
        }
        Collection nodeChildren = All.getPossibleNodeChildren((ReadGraph)graph, (AbstractChildVariable)((AbstractChildVariable)context));
        HashSet<String> used = new HashSet<String>(nodeChildren.size());
        for (ConnectionPoint connectionPoint : nodeChildren) {
            NodeManager manager = ((AbstractChildVariable)context).node.manager;
            String name = manager.getName((Object)connectionPoint);
            used.add(name);
            Component proceduralChild = (Component)proceduralChildren.get(name);
            if (proceduralChild == null) continue;
            map.put(proceduralChild.name, (Variable)new StandardProceduralChildVariable(graph, context, new VariableNode(manager, (Object)connectionPoint), proceduralChild.name, proceduralChild.type, proceduralChild.properties, conns.getValues((Object)proceduralChild.name)));
        }
        for (Map.Entry entry : proceduralChildren.entrySet()) {
            String name = (String)entry.getKey();
            if (used.contains(name)) continue;
            Component proceduralChild = (Component)entry.getValue();
            map.put(proceduralChild.name, (Variable)new StandardProceduralChildVariable(graph, context, null, proceduralChild.name, proceduralChild.type, proceduralChild.properties, conns.getValues((Object)proceduralChild.name)));
        }
        return map;
    }

    @SCLValue(type="ReadGraph -> [Resource] -> [Resource]")
    public static List<Resource> connectionExtension(ReadGraph graph, List<Resource> rs) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        HashSet extension = new HashSet(8);
        for (Resource r : rs) {
            if (graph.isInstanceOf(r, STR.Connection)) {
                extension.addAll((Collection)graph.syncRequest((Read)new ConnectionComponents(r), (Listener)TransientCacheListener.instance()));
            }
            if (!graph.isInstanceOf(r, STR.ConnectionJoin)) continue;
            extension.addAll((Collection)graph.syncRequest((Read)new ConnectionJoinComponents(r), (Listener)TransientCacheListener.instance()));
        }
        HashSet components = new HashSet(8);
        for (Resource r : extension) {
            components.addAll((Collection)graph.sync((ReadInterface)new ObjectsWithType(r, STR.Connects, STR.Component)));
        }
        if (!extension.isEmpty()) {
            ArrayList<Resource> result = new ArrayList<Resource>(rs.size() + extension.size());
            result.addAll(rs);
            result.addAll(extension);
            result.addAll(components);
            rs = result;
        }
        return rs;
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> connectionValidator(ReadGraph graph, Resource component) throws DatabaseException {
        if (!graph.hasStatement(component)) {
            return Collections.emptyList();
        }
        ArrayList<Issue> result = new ArrayList<Issue>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = graph.getSingleType(component, sr.Component);
        HashSet<Resource> requiredConnections = new HashSet<Resource>();
        for (Resource connectionRelation : (Collection)graph.sync((ReadInterface)new ObjectsWithType(type, L0.ConsistsOf, sr.ConnectionRelation))) {
            Boolean required = (Boolean)graph.getPossibleRelatedValue(connectionRelation, sr.ConnectionRelation_connectionRequired, (Binding)Bindings.BOOLEAN);
            if (required == null || !required.booleanValue()) continue;
            requiredConnections.add(connectionRelation);
        }
        HashSet<Resource> connections = new HashSet<Resource>();
        for (Statement stm : graph.getStatements(component, sr.IsConnectedTo)) {
            connections.add(stm.getPredicate());
            connections.addAll(graph.getSuperrelations(stm.getPredicate()));
        }
        for (Resource req : requiredConnections) {
            if (connections.contains(req)) continue;
            result.add((Issue)new StandardIssue(sr.ConnectionConstraint_ErrorIssue, new Resource[]{component, req}));
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String connectionIssueDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List contexts = IssueUtils.getContextsForProperty((ReadGraph)graph, (Variable)property);
        String attributeName = (String)graph.getRelatedValue((Resource)contexts.get(1), Layer0.getInstance((ReadGraph)graph).HasName);
        return "'" + attributeName + "' should be connected.";
    }

    public static String resolveInterfacePath(ReadGraph graph, Variable context, String component, Resource relation) throws DatabaseException {
        Map map = (Map)graph.syncRequest((Read)new InterfacePathMap(context), (Listener)TransientCacheListener.instance());
        Map childMap = (Map)map.get(component);
        if (childMap == null) {
            return "";
        }
        PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(relation), (Listener)TransientCacheListener.instance());
        String match = (String)childMap.get(info.name);
        if (match != null) {
            return "/" + component + match;
        }
        return "/" + component + "#" + info.name;
    }

    public static Variable resolveInterface(ReadGraph graph, StructuralResource2 STR, Variable context) throws DatabaseException {
        Resource type = context.getPossibleType(graph);
        if (type != null) {
            if (graph.isInstanceOf(type, STR.ProceduralComponentType)) {
                ArrayList<String> result = new ArrayList<String>();
                List<SubstructureElement> elements = Functions.getProceduralDesc(graph, context);
                if (elements != null) {
                    for (SubstructureElement e : elements) {
                        if (!(e instanceof org.simantics.structural2.procedural.Connection)) continue;
                        org.simantics.structural2.procedural.Connection conn = (org.simantics.structural2.procedural.Connection)e;
                        Terminal t = null;
                        Interface inf = null;
                        for (ConnectionPoint cp : conn.connectionPoints) {
                            if (cp instanceof Interface) {
                                inf = (Interface)cp;
                            }
                            if (!(cp instanceof Terminal)) continue;
                            t = (Terminal)cp;
                        }
                        if (!(t != null & inf != null)) continue;
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        String path = Functions.resolveInterfacePath(graph, context, t.component, t.relation);
                        String cpName = (String)graph.getRelatedValue(inf.relation, L0.HasName, (Binding)Bindings.STRING);
                        result.add(cpName);
                        result.add(path);
                    }
                }
                return new ConstantPropertyVariable(context, "proceduralConnectionPointPath", (Object)result.toArray(new String[result.size()]), (Binding)Bindings.STRING_ARRAY);
            }
            Resource definition = graph.getPossibleObject(type, STR.IsDefinedBy);
            if (definition != null) {
                ArrayList<String> result = new ArrayList<String>();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (Resource cp : (Collection)graph.sync((ReadInterface)new ObjectsWithType(type, L0.ConsistsOf, STR.ConnectionRelation))) {
                    for (Resource conn : graph.getObjects(cp, STR.IsBoundBy)) {
                        Statement stm = graph.getPossibleStatement(conn, STR.Connects);
                        if (stm == null) continue;
                        Resource component = stm.getObject();
                        String componentName = (String)graph.getRelatedValue(component, L0.HasName, (Binding)Bindings.STRING);
                        String cpName = (String)graph.getRelatedValue(cp, L0.HasName, (Binding)Bindings.STRING);
                        String path = Functions.resolveInterfacePath(graph, context, componentName, graph.getInverse(stm.getPredicate()));
                        if (path.isEmpty()) continue;
                        result.add(cpName);
                        result.add(path);
                    }
                }
                return new ConstantPropertyVariable(context, "proceduralConnectionPointPath", (Object)result.toArray(new String[result.size()]), (Binding)Bindings.STRING_ARRAY);
            }
        }
        return new ConstantPropertyVariable(context, "proceduralConnectionPointPath", (Object)BUILTIN_STRUCTURAL_CPS, (Binding)Bindings.STRING_ARRAY);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object computeExpression(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        try {
            Object value;
            CompiledExpression exp = (CompiledExpression)graph.syncRequest((Read)new CompileSCLValueRequest(graph, context), (Listener)TransientCacheListener.instance());
            sclContext.put((Object)"graph", (Object)graph);
            Object object = value = exp.evaluate(graph, new VariableStructuralContext(graph, context));
            return object;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.remove((Object)"graph");
        }
    }

    public static Object computeExpressionInContext(ReadGraph graph, Variable context, final String expression) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        try {
            Object value;
            CompiledExpression exp = (CompiledExpression)graph.syncRequest((Read)new CompileSCLValueRequest(graph, context){

                @Override
                protected String getExpression(ReadGraph graph) throws DatabaseException {
                    return expression;
                }
            }, (Listener)TransientCacheListener.instance());
            sclContext.put((Object)"graph", (Object)graph);
            Object object = value = exp.evaluate(graph, new VariableStructuralContext(graph, context));
            return object;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.remove((Object)"graph");
        }
    }

    static class ConnectionImpl
    implements Connection {
        private final Variable parent;
        private final Resource cp;

        public ConnectionImpl(Variable parent, Resource cp) {
            this.parent = parent;
            this.cp = cp;
        }

        @Override
        public Collection<Variable> getConnectionPoints(ReadGraph graph) throws DatabaseException {
            Variable vcp = this.parent.getPossibleProperty(graph, this.cp);
            if (vcp == null) {
                return Collections.emptyList();
            }
            THashSet result = new THashSet();
            for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, this.parent, this.cp)) {
                result.add(desc.variable);
            }
            return result;
        }

        @Override
        public Collection<String> getConnectionPointURIs(ReadGraph graph) throws DatabaseException {
            Variable vcp = this.parent.getPossibleProperty(graph, this.cp);
            if (vcp == null) {
                return Collections.emptyList();
            }
            THashSet result = new THashSet();
            for (VariableConnectionPointDescriptor desc : ConnectionBrowser.flatten(graph, this.parent, this.cp)) {
                result.add(desc.uri);
            }
            return result;
        }
    }

    public static class InterfacePathMap
    extends VariableRead<Map<String, Map<String, String>>> {
        public InterfacePathMap(Variable context) {
            super(context);
        }

        public Map<String, Map<String, String>> perform(ReadGraph graph) throws DatabaseException {
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
            for (Variable child : this.variable.getChildren(graph)) {
                HashMap<String, String> childMap = new HashMap<String, String>();
                String[] paths = (String[])child.getPossiblePropertyValue(graph, "proceduralConnectionPointPath");
                if (paths != null) {
                    int i = 0;
                    while (i < paths.length) {
                        childMap.put(paths[i], paths[i + 1]);
                        i += 2;
                    }
                }
                result.put(child.getName(graph), childMap);
            }
            return result;
        }
    }

    private static class ProceduralSubstructureRequest
    extends VariableRead<Map<String, Variable>> {
        public ProceduralSubstructureRequest(Variable variable) {
            super(variable);
        }

        public Map<String, Variable> perform(ReadGraph graph) throws DatabaseException {
            List<SubstructureElement> elements = Functions.getProceduralDesc(graph, this.variable);
            if (elements != null) {
                return Functions.getProcedural(graph, this.variable, elements, null);
            }
            return null;
        }
    }

    static class StructuralChildMapOfResource
    extends ResourceRead<Map<String, Resource>> {
        public StructuralChildMapOfResource(Resource resource) {
            super(resource);
        }

        public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
            Map map;
            Resource definition;
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Map directChildren = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(this.resource));
            Resource type = graph.getPossibleType(this.resource, STR.Component);
            if (type != null && (definition = graph.getPossibleObject(type, STR.IsDefinedBy)) != null && !(map = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(definition))).isEmpty()) {
                return map;
            }
            return directChildren;
        }
    }

    static class StructuralChildMapOfResourceT
    extends ResourceRead<Map<String, Resource>> {
        public StructuralChildMapOfResourceT(Resource resource) {
            super(resource);
        }

        public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
            Map map;
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource definition = graph.getPossibleObject(this.resource, STR.IsDefinedBy);
            if (definition != null && !(map = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(definition))).isEmpty()) {
                return map;
            }
            return Collections.emptyMap();
        }
    }

    static class StructuralRunChildMapOfResource
    extends ResourceRead<Map<String, Resource>> {
        public StructuralRunChildMapOfResource(Resource resource) {
            super(resource);
        }

        public Map<String, Resource> fromContext(ReadGraph graph, Resource context) throws DatabaseException {
            return (Map)graph.sync((ReadInterface)new StructuralChildMapOfResource(context));
        }

        public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
            Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(this.resource));
            if (graph.isInstanceOf(model, L0.RVIContext)) {
                return this.fromContext(graph, model);
            }
            Resource configuration = graph.getPossibleObject(model, SIMU.HasConfiguration);
            if (configuration != null && graph.isInstanceOf(configuration, L0.RVIContext)) {
                return this.fromContext(graph, configuration);
            }
            return Collections.emptyMap();
        }
    }

    private static class SubstructureRequest
    extends VariableRead<List<SubstructureElement>> {
        public SubstructureRequest(Variable context) {
            super(context);
        }

        public List<SubstructureElement> perform(ReadGraph graph) {
            Resource type;
            block3: {
                try {
                    type = this.variable.getPossibleType(graph);
                    if (type != null) break block3;
                    return null;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            }
            CompiledExpressionVariable exp = (CompiledExpressionVariable)graph.syncRequest((Read)new CompileProceduralComponentType(type));
            SCLContext sclContext = SCLContext.getCurrent();
            sclContext.put((Object)"graph", (Object)graph);
            List elements = (List)exp.evaluate(graph, this.variable);
            sclContext.remove((Object)"graph");
            return elements;
        }
    }
}

