/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.FloatArgument;
import com.lowagie.toolbox.arguments.IntegerArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Watermarker
extends AbstractTool {
    FileArgument destfile = null;

    static {
        Watermarker.addVersion("$Id: Watermarker.java 3271 2008-04-18 20:39:42Z xlv $");
    }

    public Watermarker() {
        FileArgument inputfile = new FileArgument(this, "srcfile", "The file you want to watermark", false, new PdfFilter());
        this.arguments.add(inputfile);
        this.arguments.add(new StringArgument(this, "watermark", "The text that can be used as watermark"));
        this.arguments.add(new IntegerArgument(this, "fontsize", "The fontsize of the watermark text"));
        this.arguments.add(new FloatArgument(this, "opacity", "The opacity of the watermark text"));
        this.destfile = new FileArgument(this, "destfile", "The file to which the watermarked PDF has to be written", true, new PdfFilter());
        this.arguments.add(this.destfile);
        inputfile.addPropertyChangeListener(this.destfile);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Watermark", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Watermark OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            if (this.getValue("watermark") == null) {
                throw new InstantiationException("You need to add a text for the watermark");
            }
            int fontsize = Integer.parseInt((String)this.getValue("fontsize"));
            float opacity = Float.parseFloat((String)this.getValue("opacity"));
            BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", false);
            PdfReader reader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            int pagecount = reader.getNumberOfPages();
            PdfGState gs1 = new PdfGState();
            gs1.setFillOpacity(opacity);
            String text = (String)this.getValue("watermark");
            PdfStamper stamp = new PdfStamper(reader, new FileOutputStream((File)this.getValue("destfile")));
            float txtwidth = bf.getWidthPoint(text, (float)fontsize);
            int i = 1;
            while (i <= pagecount) {
                PdfContentByte seitex = stamp.getOverContent(i);
                Rectangle recc = reader.getCropBox(i);
                float winkel = (float)Math.atan(recc.getHeight() / recc.getWidth());
                float m1 = (float)Math.cos(winkel);
                float m2 = (float)(-Math.sin(winkel));
                float m3 = (float)Math.sin(winkel);
                float m4 = (float)Math.cos(winkel);
                float xoff = (float)(-Math.cos(winkel) * (double)txtwidth / 2.0 - Math.sin(winkel) * (double)fontsize / 2.0);
                float yoff = (float)(Math.sin(winkel) * (double)txtwidth / 2.0 - Math.cos(winkel) * (double)fontsize / 2.0);
                seitex.saveState();
                seitex.setGState(gs1);
                seitex.beginText();
                seitex.setFontAndSize(bf, fontsize);
                seitex.setTextMatrix(m1, m2, m3, m4, xoff + recc.getWidth() / 2.0f, yoff + recc.getHeight() / 2.0f);
                seitex.showText(text);
                seitex.endText();
                seitex.restoreState();
                ++i;
            }
            stamp.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
        if (this.destfile.getValue() == null && arg.getName().equalsIgnoreCase("srcfile")) {
            String filename = arg.getValue().toString();
            String filenameout = String.valueOf(filename.substring(0, filename.indexOf(".", filename.length() - 4))) + "_out.pdf";
            this.destfile.setValue(filenameout);
        }
    }

    public static void main(String[] args) {
        Watermarker watermarker = new Watermarker();
        if (args.length != 5) {
            System.err.println(watermarker.getUsage());
        }
        watermarker.setMainArguments(args);
        watermarker.execute();
    }
}

