/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TiffImage;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.OptionArgument;
import com.lowagie.toolbox.arguments.filters.ImageFilter;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Tiff2Pdf
extends AbstractTool {
    static {
        Tiff2Pdf.addVersion("$Id: Tiff2Pdf.java 3271 2008-04-18 20:39:42Z xlv $");
    }

    public Tiff2Pdf() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to convert", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
        OptionArgument oa = new OptionArgument(this, "pagesize", "Pagesize");
        oa.addOption("A4", "A4");
        oa.addOption("Letter", "LETTER");
        oa.addOption("Original format", "ORIGINAL");
        this.arguments.add(oa);
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Tiff2Pdf", true, false, true);
        this.internalFrame.setSize(550, 250);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Tiff2Pdf OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File tiff_file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File pdf_file = (File)this.getValue("destfile");
            RandomAccessFileOrArray ra = new RandomAccessFileOrArray(tiff_file.getAbsolutePath());
            int comps = TiffImage.getNumberOfPages(ra);
            boolean adjustSize = false;
            Document document = new Document(PageSize.A4);
            float width = PageSize.A4.getWidth() - 40.0f;
            float height = PageSize.A4.getHeight() - 120.0f;
            if ("ORIGINAL".equals(this.getValue("pagesize"))) {
                Image img = TiffImage.getTiffImage(ra, 1);
                if (img.getDpiX() > 0 && img.getDpiY() > 0) {
                    img.scalePercent(7200.0f / (float)img.getDpiX(), 7200.0f / (float)img.getDpiY());
                }
                document.setPageSize(new Rectangle(img.getScaledWidth(), img.getScaledHeight()));
                adjustSize = true;
            } else if ("LETTER".equals(this.getValue("pagesize"))) {
                document.setPageSize(PageSize.LETTER);
                width = PageSize.LETTER.getWidth() - 40.0f;
                height = PageSize.LETTER.getHeight() - 120.0f;
            }
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(pdf_file));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int c = 0;
            while (c < comps) {
                Image img = TiffImage.getTiffImage(ra, c + 1);
                if (img != null) {
                    if (img.getDpiX() > 0 && img.getDpiY() > 0) {
                        img.scalePercent(7200.0f / (float)img.getDpiX(), 7200.0f / (float)img.getDpiY());
                    }
                    if (adjustSize) {
                        document.setPageSize(new Rectangle(img.getScaledWidth(), img.getScaledHeight()));
                        document.newPage();
                        img.setAbsolutePosition(0.0f, 0.0f);
                    } else {
                        if (img.getScaledWidth() > width || img.getScaledHeight() > height) {
                            if (img.getDpiX() > 0 && img.getDpiY() > 0) {
                                float adjx = width / img.getScaledWidth();
                                float adjy = height / img.getScaledHeight();
                                float adj = Math.min(adjx, adjy);
                                img.scalePercent(7200.0f / (float)img.getDpiX() * adj, 7200.0f / (float)img.getDpiY() * adj);
                            } else {
                                img.scaleToFit(width, height);
                            }
                        }
                        img.setAbsolutePosition(20.0f, 20.0f);
                        document.newPage();
                        document.add(new Paragraph(tiff_file + " - page " + (c + 1)));
                    }
                    cb.addImage(img);
                    System.out.println("Finished page " + (c + 1));
                }
                ++c;
            }
            ra.close();
            document.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        Tiff2Pdf tool = new Tiff2Pdf();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

