/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.factories.ElementFactory;
import com.lowagie.text.html.HtmlTagMap;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.draw.LineSeparator;
import com.lowagie.text.xml.simpleparser.EntitiesToSymbol;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXiTextHandler
extends DefaultHandler {
    protected DocListener document;
    protected Stack stack;
    protected int chapters = 0;
    protected Chunk currentChunk = null;
    protected boolean ignore = false;
    protected boolean controlOpenClose = true;
    float topMargin = 36.0f;
    float rightMargin = 36.0f;
    float leftMargin = 36.0f;
    float bottomMargin = 36.0f;
    protected HashMap myTags;
    private BaseFont bf = null;

    public SAXiTextHandler(DocListener document) {
        this.document = document;
        this.stack = new Stack();
    }

    public SAXiTextHandler(DocListener document, HtmlTagMap myTags) {
        this(document);
        this.myTags = myTags;
    }

    public SAXiTextHandler(DocListener document, HtmlTagMap myTags, BaseFont bf) {
        this(document, myTags);
        this.bf = bf;
    }

    public SAXiTextHandler(DocListener document, HashMap myTags) {
        this(document);
        this.myTags = myTags;
    }

    public void setControlOpenClose(boolean controlOpenClose) {
        this.controlOpenClose = controlOpenClose;
    }

    @Override
    public void startElement(String uri, String lname, String name, Attributes attrs) {
        Properties attributes = new Properties();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                String attribute = attrs.getQName(i);
                attributes.setProperty(attribute, attrs.getValue(i));
                ++i;
            }
        }
        this.handleStartingTags(name, attributes);
    }

    /*
     * WARNING - void declaration
     */
    public void handleStartingTags(String name, Properties attributes) {
        if (this.ignore || "ignore".equals(name)) {
            this.ignore = true;
            return;
        }
        if (this.currentChunk != null) {
            void var3_6;
            try {
                TextElementArray textElementArray = (TextElementArray)this.stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                if (this.bf == null) {
                    Paragraph paragraph = new Paragraph("", new Font());
                }
                Paragraph paragraph = new Paragraph("", new Font(this.bf));
            }
            var3_6.add(this.currentChunk);
            this.stack.push(var3_6);
            this.currentChunk = null;
        }
        if ("chunk".equals(name)) {
            this.currentChunk = ElementFactory.getChunk(attributes);
            if (this.bf != null) {
                this.currentChunk.setFont(new Font(this.bf));
            }
            return;
        }
        if ("entity".equals(name)) {
            void var3_9;
            Font font = new Font();
            if (this.currentChunk != null) {
                this.handleEndingTags("chunk");
                Font font2 = this.currentChunk.getFont();
            }
            this.currentChunk = EntitiesToSymbol.get(attributes.getProperty("id"), (Font)var3_9);
            return;
        }
        if ("phrase".equals(name)) {
            this.stack.push(ElementFactory.getPhrase(attributes));
            return;
        }
        if ("anchor".equals(name)) {
            this.stack.push(ElementFactory.getAnchor(attributes));
            return;
        }
        if ("paragraph".equals(name) || "title".equals(name)) {
            this.stack.push(ElementFactory.getParagraph(attributes));
            return;
        }
        if ("list".equals(name)) {
            this.stack.push(ElementFactory.getList(attributes));
            return;
        }
        if ("listitem".equals(name)) {
            this.stack.push(ElementFactory.getListItem(attributes));
            return;
        }
        if ("cell".equals(name)) {
            this.stack.push(ElementFactory.getCell(attributes));
            return;
        }
        if ("table".equals(name)) {
            Table table = ElementFactory.getTable(attributes);
            float[] widths = table.getProportionalWidths();
            int i = 0;
            while (i < widths.length) {
                if (widths[i] == 0.0f) {
                    widths[i] = 100.0f / (float)widths.length;
                }
                ++i;
            }
            try {
                table.setWidths(widths);
            }
            catch (BadElementException bee) {
                throw new ExceptionConverter(bee);
            }
            this.stack.push(table);
            return;
        }
        if ("section".equals(name)) {
            Section section;
            Element element = (Element)this.stack.pop();
            try {
                section = ElementFactory.getSection((Section)element, attributes);
            }
            catch (ClassCastException cce) {
                throw new ExceptionConverter(cce);
            }
            this.stack.push(element);
            this.stack.push(section);
            return;
        }
        if ("chapter".equals(name)) {
            this.stack.push(ElementFactory.getChapter(attributes));
            return;
        }
        if ("image".equals(name)) {
            try {
                Image image = ElementFactory.getImage(attributes);
                try {
                    this.addImage(image);
                    return;
                }
                catch (EmptyStackException emptyStackException) {
                    try {
                        this.document.add(image);
                    }
                    catch (DocumentException de) {
                        throw new ExceptionConverter(de);
                    }
                    return;
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        if ("annotation".equals(name)) {
            Annotation annotation = ElementFactory.getAnnotation(attributes);
            try {
                try {
                    TextElementArray current2 = (TextElementArray)this.stack.pop();
                    try {
                        current2.add(annotation);
                    }
                    catch (Exception exception) {
                        this.document.add(annotation);
                    }
                    this.stack.push(current2);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add(annotation);
                }
                return;
            }
            catch (DocumentException de) {
                throw new ExceptionConverter(de);
            }
        }
        if (this.isNewline(name)) {
            try {
                TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                textElementArray.add(Chunk.NEWLINE);
                this.stack.push(textElementArray);
            }
            catch (EmptyStackException emptyStackException) {
                if (this.currentChunk == null) {
                    try {
                        this.document.add(Chunk.NEWLINE);
                    }
                    catch (DocumentException de) {
                        throw new ExceptionConverter(de);
                    }
                }
                this.currentChunk.append("\n");
            }
            return;
        }
        if (this.isNewpage(name)) {
            try {
                TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                Chunk newPage = new Chunk("");
                newPage.setNewPage();
                if (this.bf != null) {
                    newPage.setFont(new Font(this.bf));
                }
                textElementArray.add(newPage);
                this.stack.push(textElementArray);
            }
            catch (EmptyStackException emptyStackException) {
                this.document.newPage();
            }
            return;
        }
        if ("horizontalrule".equals(name)) {
            LineSeparator hr = new LineSeparator(1.0f, 100.0f, null, 1, 0.0f);
            try {
                TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                textElementArray.add(hr);
                this.stack.push(textElementArray);
            }
            catch (EmptyStackException emptyStackException) {
                try {
                    this.document.add(hr);
                }
                catch (DocumentException de) {
                    throw new ExceptionConverter(de);
                }
            }
            return;
        }
        if (this.isDocumentRoot(name)) {
            Rectangle pageSize = null;
            String orientation = null;
            for (String string : attributes.keySet()) {
                String value = attributes.getProperty(string);
                try {
                    if ("left".equalsIgnoreCase(string)) {
                        this.leftMargin = Float.parseFloat(String.valueOf(value) + "f");
                    }
                    if ("right".equalsIgnoreCase(string)) {
                        this.rightMargin = Float.parseFloat(String.valueOf(value) + "f");
                    }
                    if ("top".equalsIgnoreCase(string)) {
                        this.topMargin = Float.parseFloat(String.valueOf(value) + "f");
                    }
                    if ("bottom".equalsIgnoreCase(string)) {
                        this.bottomMargin = Float.parseFloat(String.valueOf(value) + "f");
                    }
                }
                catch (Exception ex) {
                    throw new ExceptionConverter(ex);
                }
                if ("pagesize".equals(string)) {
                    try {
                        String pageSizeName = value;
                        Field pageSizeField = PageSize.class.getField(pageSizeName);
                        pageSize = (Rectangle)pageSizeField.get(null);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new ExceptionConverter(ex);
                    }
                }
                if ("orientation".equals(string)) {
                    try {
                        if (!"landscape".equals(value)) continue;
                        orientation = "landscape";
                        continue;
                    }
                    catch (Exception ex) {
                        throw new ExceptionConverter(ex);
                    }
                }
                try {
                    this.document.add(new Meta(string, value));
                }
                catch (DocumentException de) {
                    throw new ExceptionConverter(de);
                }
            }
            if (pageSize != null) {
                if ("landscape".equals(orientation)) {
                    pageSize = pageSize.rotate();
                }
                this.document.setPageSize(pageSize);
            }
            this.document.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
            if (this.controlOpenClose) {
                this.document.open();
            }
        }
    }

    protected void addImage(Image img) throws EmptyStackException {
        Object current = this.stack.pop();
        if (current instanceof Chapter || current instanceof Section || current instanceof Cell) {
            ((TextElementArray)current).add(img);
            this.stack.push(current);
            return;
        }
        Stack newStack = new Stack();
        while (!(current instanceof Chapter || current instanceof Section || current instanceof Cell)) {
            newStack.push(current);
            if (current instanceof Anchor) {
                img.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, ((Anchor)current).getReference()));
            }
            current = this.stack.pop();
        }
        ((TextElementArray)current).add(img);
        this.stack.push(current);
        while (!newStack.empty()) {
            this.stack.push(newStack.pop());
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.characters(ch, start, length);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.ignore) {
            return;
        }
        String content = new String(ch, start, length);
        if (content.trim().length() == 0 && content.indexOf(32) < 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        int len = content.length();
        boolean newline = false;
        int i = 0;
        while (i < len) {
            char character = content.charAt(i);
            switch (character) {
                case ' ': {
                    if (newline) break;
                    buf.append(character);
                    break;
                }
                case '\n': {
                    if (i <= 0) break;
                    newline = true;
                    buf.append(' ');
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    break;
                }
                default: {
                    newline = false;
                    buf.append(character);
                }
            }
            ++i;
        }
        if (this.currentChunk == null) {
            this.currentChunk = this.bf == null ? new Chunk(buf.toString()) : new Chunk(buf.toString(), new Font(this.bf));
        } else {
            this.currentChunk.append(buf.toString());
        }
    }

    public void setBaseFont(BaseFont bf) {
        this.bf = bf;
    }

    @Override
    public void endElement(String uri, String lname, String name) {
        this.handleEndingTags(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleEndingTags(String name) {
        if ("ignore".equals(name)) {
            this.ignore = false;
            return;
        }
        if (this.ignore) {
            return;
        }
        if (this.isNewpage(name)) return;
        if ("annotation".equals(name)) return;
        if ("image".equals(name)) return;
        if (this.isNewline(name)) {
            return;
        }
        try {
            block44: {
                Element element;
                Element current;
                if ("title".equals(name)) {
                    Paragraph current2 = (Paragraph)this.stack.pop();
                    if (this.currentChunk != null) {
                        current2.add(this.currentChunk);
                        this.currentChunk = null;
                    }
                    Section previous = (Section)this.stack.pop();
                    previous.setTitle(current2);
                    this.stack.push(previous);
                    return;
                }
                if (this.currentChunk != null) {
                    try {
                        current = (TextElementArray)this.stack.pop();
                    }
                    catch (EmptyStackException emptyStackException) {
                        current = new Paragraph();
                    }
                    current.add(this.currentChunk);
                    this.stack.push(current);
                    this.currentChunk = null;
                }
                if ("chunk".equals(name)) {
                    return;
                }
                if ("phrase".equals(name) || "anchor".equals(name) || "list".equals(name) || "paragraph".equals(name)) {
                    current = (Element)this.stack.pop();
                    try {
                        TextElementArray previous = (TextElementArray)this.stack.pop();
                        previous.add(current);
                        this.stack.push(previous);
                        return;
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add(current);
                    }
                    return;
                }
                if ("listitem".equals(name)) {
                    ListItem listItem = (ListItem)this.stack.pop();
                    List list = (List)this.stack.pop();
                    list.add(listItem);
                    this.stack.push(list);
                }
                if ("table".equals(name)) {
                    Table table = (Table)this.stack.pop();
                    try {
                        TextElementArray previous = (TextElementArray)this.stack.pop();
                        previous.add(table);
                        this.stack.push(previous);
                        return;
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add(table);
                    }
                    return;
                }
                if (!"row".equals(name)) break block44;
                ArrayList<Cell> cells = new ArrayList<Cell>();
                int columns = 0;
                while ((element = (Element)this.stack.pop()).type() == 20) {
                    Cell cell = (Cell)element;
                    columns += cell.getColspan();
                    cells.add(cell);
                }
                Table table = (Table)element;
                if (table.getColumns() < columns) {
                    table.addColumns(columns - table.getColumns());
                }
                Collections.reverse(cells);
                float[] cellWidths = new float[columns];
                boolean[] cellNulls = new boolean[columns];
                int i = 0;
                while (i < columns) {
                    cellWidths[i] = 0.0f;
                    cellNulls[i] = true;
                    ++i;
                }
                float total = 0.0f;
                int j = 0;
                for (Cell cell : cells) {
                    block46: {
                        String width;
                        block45: {
                            width = cell.getWidthAsString();
                            if (cell.getWidth() != 0.0f) break block45;
                            if (cell.getColspan() == 1 && cellWidths[j] == 0.0f) {
                                try {
                                    cellWidths[j] = 100.0f / (float)columns;
                                    total += cellWidths[j];
                                }
                                catch (Exception exception) {}
                                break block46;
                            } else if (cell.getColspan() == 1) {
                                cellNulls[j] = false;
                            }
                            break block46;
                        }
                        if (cell.getColspan() == 1 && width.endsWith("%")) {
                            try {
                                cellWidths[j] = Float.parseFloat(String.valueOf(width.substring(0, width.length() - 1)) + "f");
                                total += cellWidths[j];
                            }
                            catch (Exception exception) {}
                        }
                    }
                    j += cell.getColspan();
                    table.addCell(cell);
                }
                float[] widths = table.getProportionalWidths();
                if (widths.length == columns) {
                    float left = 0.0f;
                    int i2 = 0;
                    while (i2 < columns) {
                        if (cellNulls[i2] && widths[i2] != 0.0f) {
                            left += widths[i2];
                            cellWidths[i2] = widths[i2];
                        }
                        ++i2;
                    }
                    if (100.0 >= (double)total) {
                        int i3 = 0;
                        while (i3 < widths.length) {
                            if (cellWidths[i3] == 0.0f && widths[i3] != 0.0f) {
                                cellWidths[i3] = widths[i3] / left * (100.0f - total);
                            }
                            ++i3;
                        }
                    }
                    table.setWidths(cellWidths);
                }
                this.stack.push(table);
            }
            if ("cell".equals(name)) {
                return;
            }
            if ("section".equals(name)) {
                this.stack.pop();
                return;
            }
            if ("chapter".equals(name)) {
                this.document.add((Element)this.stack.pop());
                return;
            }
            if (!this.isDocumentRoot(name)) return;
            try {
                while (true) {
                    Element element = (Element)this.stack.pop();
                    try {
                        TextElementArray previous = (TextElementArray)this.stack.pop();
                        previous.add(element);
                        this.stack.push(previous);
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.document.add(element);
                    }
                }
            }
            catch (EmptyStackException emptyStackException) {
                if (!this.controlOpenClose) return;
                this.document.close();
                return;
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    private boolean isNewpage(String tag) {
        return "newpage".equals(tag);
    }

    private boolean isNewline(String tag) {
        return "newline".equals(tag);
    }

    protected boolean isDocumentRoot(String tag) {
        return "itext".equals(tag);
    }
}

