/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.direct.RtfDirectContent;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationFontTable;
import com.lowagie.text.rtf.parser.properties.RtfPropertyListener;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class RtfDestinationDocument
extends RtfDestination
implements RtfPropertyListener {
    private RtfDocument rtfDoc = null;
    private Document doc = null;
    private StringBuffer buffer = null;
    private int conversionType = 0;
    private int tableLevel = 0;
    private static final List IMPORT_IGNORED_CTRLWORDS = Arrays.asList("rtf", "ansicpg", "deff", "ansi", "mac", "pca", "pc", "stshfdbch", "stshfloch", "stshfhich", "stshfbi", "deflang", "deflangfe", "adeflang", "adeflangfe");
    private static final List CONVERT_IGNORED_CTRLWORDS = Arrays.asList("rtf");
    private Paragraph iTextParagraph = null;

    public RtfDestinationDocument() {
        super(null);
    }

    public RtfDestinationDocument(RtfParser parser) {
        super(parser);
        this.rtfDoc = parser.getRtfDocument();
        this.doc = parser.getDocument();
        this.conversionType = parser.getConversionType();
        this.setToDefaults();
        if (this.rtfParser.isConvert()) {
            this.rtfParser.getState().properties.addRtfPropertyListener(this);
        }
    }

    protected void finalize() throws Throwable {
        if (this.rtfParser.isConvert()) {
            this.rtfParser.getState().properties.removeRtfPropertyListener(this);
        }
        super.finalize();
    }

    @Override
    public void setParser(RtfParser parser) {
        this.rtfParser = parser;
        this.rtfDoc = parser.getRtfDocument();
        this.doc = parser.getDocument();
        this.conversionType = parser.getConversionType();
        this.setToDefaults();
        if (this.rtfParser.isConvert()) {
            this.rtfParser.getState().properties.addRtfPropertyListener(this);
        }
    }

    @Override
    public boolean closeDestination() {
        if (this.rtfParser.isImport() && this.buffer.length() > 0) {
            this.writeBuffer();
        }
        this.rtfParser.getState().properties.removeRtfPropertyListener(this);
        return true;
    }

    @Override
    public boolean handleOpenGroup() {
        this.onOpenGroup();
        this.rtfParser.isImport();
        if (this.rtfParser.isConvert() && this.iTextParagraph == null) {
            this.iTextParagraph = new Paragraph();
        }
        return true;
    }

    @Override
    public boolean handleOpeningSubGroup() {
        if (this.rtfParser.isImport() && this.buffer.length() > 0) {
            this.writeBuffer();
        }
        return true;
    }

    @Override
    public boolean handleCloseGroup() {
        this.onCloseGroup();
        if (this.rtfParser.isImport()) {
            if (this.buffer.length() > 0) {
                this.writeBuffer();
            }
            this.writeText("}");
        }
        if (this.rtfParser.isConvert()) {
            if (this.buffer.length() > 0 && this.iTextParagraph == null) {
                this.iTextParagraph = new Paragraph();
            }
            if (this.buffer.length() > 0) {
                Chunk chunk = new Chunk();
                chunk.append(this.buffer.toString());
                this.iTextParagraph.add(chunk);
            }
            if (this.iTextParagraph != null) {
                this.addParagraphToDocument();
            }
        }
        return true;
    }

    @Override
    public boolean handleCharacter(int ch) {
        boolean result = true;
        this.onCharacter(ch);
        if (this.rtfParser.isImport()) {
            if (this.buffer.length() > 254) {
                this.writeBuffer();
            }
            this.buffer.append((char)ch);
        }
        if (this.rtfParser.isConvert()) {
            this.buffer.append((char)ch);
        }
        return result;
    }

    @Override
    public boolean handleControlWord(RtfCtrlWordData ctrlWordData) {
        boolean result = false;
        this.onCtrlWord(ctrlWordData);
        if (this.rtfParser.isImport()) {
            if (ctrlWordData.ctrlWord.equals("f")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapFontNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("cb")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("cf")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("clcbpat")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("clcbpatraw")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("clcfpat")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("clcfpatraw")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("trcfpat")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("trcbpat")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("brdrcf")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("ls")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapListNr(ctrlWordData.param);
            }
        }
        if (this.rtfParser.isConvert()) {
            if (ctrlWordData.ctrlWord.equals("par")) {
                this.addParagraphToDocument();
            }
            ctrlWordData.ctrlWord.equals("f");
            ctrlWordData.ctrlWord.equals("cb");
            ctrlWordData.ctrlWord.equals("cf");
            ctrlWordData.ctrlWord.equals("clcbpat");
            ctrlWordData.ctrlWord.equals("clcbpatraw");
            ctrlWordData.ctrlWord.equals("clcfpat");
            ctrlWordData.ctrlWord.equals("clcfpatraw");
            ctrlWordData.ctrlWord.equals("trcfpat");
            ctrlWordData.ctrlWord.equals("trcbpat");
            ctrlWordData.ctrlWord.equals("brdrcf");
            if (ctrlWordData.ctrlWord.equals("trowd")) {
                ++this.tableLevel;
            }
            ctrlWordData.ctrlWord.equals("cell");
            if (ctrlWordData.ctrlWord.equals("row")) {
                ++this.tableLevel;
            }
            ctrlWordData.ctrlWord.equals("lastrow");
            if (ctrlWordData.ctrlWord.equals("row")) {
                ++this.tableLevel;
            }
            ctrlWordData.ctrlWord.equals("irow");
            ctrlWordData.ctrlWord.equals("irowband");
            ctrlWordData.ctrlWord.equals("tcelld");
            ctrlWordData.ctrlWord.equals("nestcell");
            ctrlWordData.ctrlWord.equals("nestrow");
            ctrlWordData.ctrlWord.equals("nesttableprops");
            ctrlWordData.ctrlWord.equals("nonesttables");
            ctrlWordData.ctrlWord.equals("trgaph");
            ctrlWordData.ctrlWord.equals("cellx");
            ctrlWordData.ctrlWord.equals("clmgf");
            ctrlWordData.ctrlWord.equals("clmrg");
            ctrlWordData.ctrlWord.equals("clvmgf");
            ctrlWordData.ctrlWord.equals("clvmrg");
            ctrlWordData.ctrlWord.equals("trauth");
            ctrlWordData.ctrlWord.equals("trdate");
            ctrlWordData.ctrlWord.equals("tbllkborder");
            ctrlWordData.ctrlWord.equals("tbllkshading");
            ctrlWordData.ctrlWord.equals("tbllkfont");
            ctrlWordData.ctrlWord.equals("tbllkcolor");
            ctrlWordData.ctrlWord.equals("tbllkbestfit");
            ctrlWordData.ctrlWord.equals("tbllkhdrrows");
            ctrlWordData.ctrlWord.equals("tbllklastrow");
            ctrlWordData.ctrlWord.equals("tbllkhdrcols");
            ctrlWordData.ctrlWord.equals("tbllklastcol");
            ctrlWordData.ctrlWord.equals("tbllknorowband");
            ctrlWordData.ctrlWord.equals("tbllknocolband");
            ctrlWordData.ctrlWord.equals("taprtl");
            ctrlWordData.ctrlWord.equals("trautofit");
            ctrlWordData.ctrlWord.equals("trhdr");
            ctrlWordData.ctrlWord.equals("trkeep");
            ctrlWordData.ctrlWord.equals("trkeepfollow");
            ctrlWordData.ctrlWord.equals("trleft");
            ctrlWordData.ctrlWord.equals("trqc");
            ctrlWordData.ctrlWord.equals("trql");
            ctrlWordData.ctrlWord.equals("trqr");
            ctrlWordData.ctrlWord.equals("trrh");
            ctrlWordData.ctrlWord.equals("trpaddb");
            ctrlWordData.ctrlWord.equals("trpaddl");
            ctrlWordData.ctrlWord.equals("trpaddr");
            ctrlWordData.ctrlWord.equals("trpaddt");
            ctrlWordData.ctrlWord.equals("trpaddfb");
            ctrlWordData.ctrlWord.equals("trpaddfl");
            ctrlWordData.ctrlWord.equals("trpaddfr");
            ctrlWordData.ctrlWord.equals("trpaddft");
            ctrlWordData.ctrlWord.equals("trspdl");
            ctrlWordData.ctrlWord.equals("trspdt");
            ctrlWordData.ctrlWord.equals("trspdb");
            ctrlWordData.ctrlWord.equals("trspdr");
            ctrlWordData.ctrlWord.equals("trspdfl");
            ctrlWordData.ctrlWord.equals("trspdft");
            ctrlWordData.ctrlWord.equals("trspdfb");
            ctrlWordData.ctrlWord.equals("trspdfr");
            ctrlWordData.ctrlWord.equals("trwWidth");
            ctrlWordData.ctrlWord.equals("trftsWidth");
            ctrlWordData.ctrlWord.equals("trwWidthB");
            ctrlWordData.ctrlWord.equals("trftsWidthB");
            ctrlWordData.ctrlWord.equals("trftsWidthB");
            ctrlWordData.ctrlWord.equals("trwWidthA");
            ctrlWordData.ctrlWord.equals("trftsWidthA");
            ctrlWordData.ctrlWord.equals("tblind");
            ctrlWordData.ctrlWord.equals("tblindtype");
            ctrlWordData.ctrlWord.equals("trcbpat");
            ctrlWordData.ctrlWord.equals("trcfpat");
            ctrlWordData.ctrlWord.equals("trpat");
            ctrlWordData.ctrlWord.equals("trshdng");
            ctrlWordData.ctrlWord.equals("trbgbdiag");
            ctrlWordData.ctrlWord.equals("trbgcross");
            ctrlWordData.ctrlWord.equals("trbgdcross");
            ctrlWordData.ctrlWord.equals("trbgdkbdiag");
            ctrlWordData.ctrlWord.equals("trbgdkcross");
            ctrlWordData.ctrlWord.equals("trbgdkdcross");
            ctrlWordData.ctrlWord.equals("trbgdkfdiag");
            ctrlWordData.ctrlWord.equals("trbgdkhor");
            ctrlWordData.ctrlWord.equals("trbgdkvert");
            ctrlWordData.ctrlWord.equals("trbgfdiag");
            ctrlWordData.ctrlWord.equals("trbghoriz");
            ctrlWordData.ctrlWord.equals("trbgvert");
            ctrlWordData.ctrlWord.equals("clFitText");
            ctrlWordData.ctrlWord.equals("clNoWrap");
            ctrlWordData.ctrlWord.equals("clpadl");
            ctrlWordData.ctrlWord.equals("clpadt");
            ctrlWordData.ctrlWord.equals("clpadb");
            ctrlWordData.ctrlWord.equals("clpadr");
            ctrlWordData.ctrlWord.equals("clpadfl");
            ctrlWordData.ctrlWord.equals("clpadft");
            ctrlWordData.ctrlWord.equals("clpadfb");
            ctrlWordData.ctrlWord.equals("clpadfr");
            ctrlWordData.ctrlWord.equals("clwWidth");
            ctrlWordData.ctrlWord.equals("clftsWidth");
            ctrlWordData.ctrlWord.equals("clhidemark");
            ctrlWordData.ctrlWord.equals("clins");
            ctrlWordData.ctrlWord.equals("cldel");
            ctrlWordData.ctrlWord.equals("clmrgd");
            ctrlWordData.ctrlWord.equals("clmrgdr");
            ctrlWordData.ctrlWord.equals("clsplit");
            ctrlWordData.ctrlWord.equals("clsplitr");
            ctrlWordData.ctrlWord.equals("clinsauth");
            ctrlWordData.ctrlWord.equals("clinsdttm");
            ctrlWordData.ctrlWord.equals("cldelauth");
            ctrlWordData.ctrlWord.equals("cldeldttm");
            ctrlWordData.ctrlWord.equals("clmrgdauth");
            ctrlWordData.ctrlWord.equals("clmrgddttm");
            ctrlWordData.ctrlWord.equals("tdfrmtxtLeft");
            ctrlWordData.ctrlWord.equals("tdfrmtxtRight");
            ctrlWordData.ctrlWord.equals("tdfrmtxtTop");
            ctrlWordData.ctrlWord.equals("tdfrmtxtBottom");
            ctrlWordData.ctrlWord.equals("tabsnoovrlp");
            ctrlWordData.ctrlWord.equals("tphcol");
            ctrlWordData.ctrlWord.equals("tphmrg");
            ctrlWordData.ctrlWord.equals("tphpg");
            ctrlWordData.ctrlWord.equals("tposnegx");
            ctrlWordData.ctrlWord.equals("tposnegy");
            ctrlWordData.ctrlWord.equals("tposx");
            ctrlWordData.ctrlWord.equals("tposxc");
            ctrlWordData.ctrlWord.equals("tposxi");
            ctrlWordData.ctrlWord.equals("tposxl");
            ctrlWordData.ctrlWord.equals("tposxo");
            ctrlWordData.ctrlWord.equals("tposxr");
            ctrlWordData.ctrlWord.equals("tposy");
            ctrlWordData.ctrlWord.equals("tposyb");
            ctrlWordData.ctrlWord.equals("tposyc");
            ctrlWordData.ctrlWord.equals("tposyil");
            ctrlWordData.ctrlWord.equals("tposyin");
            ctrlWordData.ctrlWord.equals("tposyout");
            ctrlWordData.ctrlWord.equals("tposyt");
            ctrlWordData.ctrlWord.equals("tpvmrg");
            ctrlWordData.ctrlWord.equals("tpvpara");
            ctrlWordData.ctrlWord.equals("tpvpg");
            ctrlWordData.ctrlWord.equals("rtlrow");
            ctrlWordData.ctrlWord.equals("ltrrow");
            ctrlWordData.ctrlWord.equals("trbrdrt");
            ctrlWordData.ctrlWord.equals("trbrdrl");
            ctrlWordData.ctrlWord.equals("trbrdrb");
            ctrlWordData.ctrlWord.equals("trbrdrr");
            ctrlWordData.ctrlWord.equals("trbrdrh");
            ctrlWordData.ctrlWord.equals("trbrdrv");
            ctrlWordData.ctrlWord.equals("brdrnil");
            ctrlWordData.ctrlWord.equals("clbrdrb");
            ctrlWordData.ctrlWord.equals("clbrdrt");
            ctrlWordData.ctrlWord.equals("clbrdrl");
            ctrlWordData.ctrlWord.equals("clbrdrr");
            ctrlWordData.ctrlWord.equals("cldglu");
            ctrlWordData.ctrlWord.equals("cldgll");
        }
        if (ctrlWordData.ctrlWordType == 4) {
            this.rtfParser.getState().properties.toggleProperty(ctrlWordData);
        }
        if (ctrlWordData.ctrlWordType == 2 || ctrlWordData.ctrlWordType == 3) {
            this.rtfParser.getState().properties.setProperty(ctrlWordData);
        }
        switch (this.conversionType) {
            case 0: {
                if (!IMPORT_IGNORED_CTRLWORDS.contains(ctrlWordData.ctrlWord)) {
                    this.writeBuffer();
                    this.writeText(ctrlWordData.toString());
                }
                result = true;
                break;
            }
            case 1: {
                if (!IMPORT_IGNORED_CTRLWORDS.contains(ctrlWordData.ctrlWord)) {
                    this.writeBuffer();
                    this.writeText(ctrlWordData.toString());
                }
                result = true;
                break;
            }
            case 2: {
                IMPORT_IGNORED_CTRLWORDS.contains(ctrlWordData.ctrlWord);
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private void writeBuffer() {
        this.writeText(this.buffer.toString());
        this.setToDefaults();
    }

    private void writeText(String value) {
        if (this.rtfParser.isNewGroup()) {
            this.rtfDoc.add(new RtfDirectContent("{"));
            this.rtfParser.setNewGroup(false);
        }
        if (value.length() > 0) {
            this.rtfDoc.add(new RtfDirectContent(value));
        }
    }

    @Override
    public void setToDefaults() {
        this.buffer = new StringBuffer(255);
    }

    @Override
    public void afterPropertyChange(String propertyName) {
        if (!(propertyName.startsWith("character.") || propertyName.startsWith("paragraph.") || propertyName.startsWith("section."))) {
            propertyName.startsWith("document.");
        }
    }

    @Override
    public void beforePropertyChange(String propertyName) {
        if (this.buffer.length() == 0) {
            return;
        }
        if (propertyName.startsWith("character.")) {
            Chunk chunk = new Chunk();
            chunk.append(this.buffer.toString());
            this.buffer = new StringBuffer(255);
            HashMap charProperties = this.rtfParser.getState().properties.getProperties("character.");
            String defFont = (String)charProperties.get("character.font");
            if (defFont == null) {
                defFont = "0";
            }
            RtfDestinationFontTable fontTable = (RtfDestinationFontTable)this.rtfParser.getDestination("fonttbl");
            Font currFont = fontTable.getFont(defFont);
            int fs = 0;
            if (charProperties.containsKey("character.bold")) {
                fs |= 1;
            }
            if (charProperties.containsKey("character.italic")) {
                fs |= 2;
            }
            if (charProperties.containsKey("character.underline")) {
                fs |= 4;
            }
            Font useFont = FontFactory.getFont(currFont.getFamilyname(), 12.0f, fs, new Color(0, 0, 0));
            chunk.setFont(useFont);
            if (this.iTextParagraph == null) {
                this.iTextParagraph = new Paragraph();
            }
            this.iTextParagraph.add(chunk);
        } else if (!propertyName.startsWith("paragraph.") && !propertyName.startsWith("section.")) {
            propertyName.startsWith("document.");
        }
    }

    private void addParagraphToDocument() {
        if (this.iTextParagraph != null) {
            try {
                this.rtfParser.getDocument().add(this.iTextParagraph);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            this.iTextParagraph = null;
        }
    }
}

