/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.DocWriter;
import com.lowagie.text.ListItem;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfListLevel;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.IOException;
import java.io.OutputStream;

public class RtfListItem
extends RtfParagraph {
    private RtfListLevel parentList = null;
    private boolean containsInnerList = false;
    private int level = 0;

    public RtfListItem(RtfDocument doc, ListItem listItem) {
        super(doc, listItem);
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        if (this.paragraphStyle.getSpacingBefore() > 0) {
            result.write(RtfParagraphStyle.SPACING_BEFORE);
            result.write(this.intToByteArray(this.paragraphStyle.getSpacingBefore()));
        }
        if (this.paragraphStyle.getSpacingAfter() > 0) {
            result.write(RtfParagraphStyle.SPACING_AFTER);
            result.write(this.intToByteArray(this.paragraphStyle.getSpacingAfter()));
        }
        if (this.paragraphStyle.getLineLeading() > 0) {
            result.write(RtfParagraph.LINE_SPACING);
            result.write(this.intToByteArray(this.paragraphStyle.getLineLeading()));
        }
        int i = 0;
        while (i < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (rtfElement instanceof RtfChunk) {
                ((RtfChunk)rtfElement).setSoftLineBreaks(true);
            } else if (rtfElement instanceof RtfList) {
                result.write(RtfParagraph.PARAGRAPH);
                this.containsInnerList = true;
            }
            rtfElement.writeContent(result);
            if (rtfElement instanceof RtfList) {
                switch (this.parentList.getLevelFollowValue()) {
                    case 2: {
                        break;
                    }
                    case 0: {
                        this.parentList.writeListBeginning(result);
                        result.write(RtfList.TAB);
                        break;
                    }
                    case 1: {
                        this.parentList.writeListBeginning(result);
                        result.write(DocWriter.getISOBytes(" "));
                    }
                }
            }
            ++i;
        }
    }

    public boolean writeDefinition(OutputStream out) throws IOException {
        int i = 0;
        while (i < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (rtfElement instanceof RtfList) {
                RtfList rl = (RtfList)rtfElement;
                rl.writeDefinition(out);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void inheritListSettings(int listNumber, int listLevel) {
        int i = 0;
        while (i < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (rtfElement instanceof RtfList) {
                ((RtfList)rtfElement).setListNumber(listNumber);
                this.setLevel(listLevel);
            }
            ++i;
        }
    }

    protected void correctIndentation() {
        int i = 0;
        while (i < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i);
            if (rtfElement instanceof RtfList) {
                ((RtfList)rtfElement).correctIndentation();
            }
            ++i;
        }
    }

    public void setParent(RtfListLevel parentList) {
        this.parentList = parentList;
    }

    public RtfListLevel getParent() {
        return this.parentList;
    }

    public boolean isContainsInnerList() {
        return this.containsInnerList;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

