/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.codec.wmf.MetaDo;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.output.RtfByteArrayBuffer;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RtfImage
extends RtfElement {
    private static final byte[] PICTURE_GROUP = DocWriter.getISOBytes("\\*\\shppict");
    private static final byte[] PICTURE = DocWriter.getISOBytes("\\pict");
    private static final byte[] PICTURE_JPEG = DocWriter.getISOBytes("\\jpegblip");
    private static final byte[] PICTURE_PNG = DocWriter.getISOBytes("\\pngblip");
    private static final byte[] PICTURE_WMF = DocWriter.getISOBytes("\\wmetafile8");
    private static final byte[] PICTURE_WIDTH = DocWriter.getISOBytes("\\picw");
    private static final byte[] PICTURE_HEIGHT = DocWriter.getISOBytes("\\pich");
    private static final byte[] PICTURE_SCALED_WIDTH = DocWriter.getISOBytes("\\picwgoal");
    private static final byte[] PICTURE_SCALED_HEIGHT = DocWriter.getISOBytes("\\pichgoal");
    private static final byte[] PICTURE_SCALE_X = DocWriter.getISOBytes("\\picscalex");
    private static final byte[] PICTURE_SCALE_Y = DocWriter.getISOBytes("\\picscaley");
    private static final byte[] PICTURE_BINARY_DATA = DocWriter.getISOBytes("\\bin");
    private static final int PIXEL_TWIPS_FACTOR = 15;
    private final int imageType;
    private final byte[][] imageData;
    private int alignment = 0;
    private float width = 0.0f;
    private float height = 0.0f;
    private float plainWidth = 0.0f;
    private float plainHeight = 0.0f;
    private boolean topLevelElement = false;
    public static final byte[] byte2charLUT = new byte[512];

    static {
        int c = 48;
        int k = 0;
        while (k < 16) {
            int x = 0;
            while (x < 16) {
                byte by = (byte)c;
                RtfImage.byte2charLUT[(x * 16 + k) * 2 + 1] = by;
                RtfImage.byte2charLUT[(k * 16 + x) * 2] = by;
                ++x;
            }
            char c2 = (char)(c + 1);
            c = c2;
            if (c2 == ':') {
                c = 97;
            }
            ++k;
        }
    }

    public RtfImage(RtfDocument doc, Image image) throws DocumentException {
        super(doc);
        this.imageType = image.getOriginalType();
        if (this.imageType != 1 && this.imageType != 4 && this.imageType != 2 && this.imageType != 6 && this.imageType != 3) {
            throw new DocumentException("Only BMP, PNG, WMF, GIF and JPEG images are supported by the RTF Writer");
        }
        this.alignment = image.getAlignment();
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.plainWidth = image.getPlainWidth();
        this.plainHeight = image.getPlainHeight();
        this.imageData = this.getImageData(image);
    }

    private byte[][] getImageData(Image image) throws DocumentException {
        RtfByteArrayBuffer bab = new RtfByteArrayBuffer();
        try {
            if (this.imageType == 4) {
                bab.append(MetaDo.wrapBMP(image));
            } else {
                byte[] iod = image.getOriginalData();
                if (iod == null) {
                    InputStream imageIn = image.getUrl().openStream();
                    if (this.imageType == 6) {
                        int k = 0;
                        while (k < 22) {
                            if (imageIn.read() < 0) {
                                throw new EOFException("while removing wmf placeable header");
                            }
                            ++k;
                        }
                    }
                    bab.write(imageIn);
                    imageIn.close();
                } else if (this.imageType == 6) {
                    bab.write(iod, 22, iod.length - 22);
                } else {
                    bab.append(iod);
                }
            }
            return bab.toByteArrayArray();
        }
        catch (IOException ioe) {
            throw new DocumentException(ioe.getMessage());
        }
    }

    private void writeImageDataHexEncoded(OutputStream bab) throws IOException {
        int cnt = 0;
        int k = 0;
        while (k < this.imageData.length) {
            byte[] chunk = this.imageData[k];
            int x = 0;
            while (x < chunk.length) {
                bab.write(byte2charLUT, (chunk[x] & 0xFF) * 2, 2);
                if (++cnt == 64) {
                    bab.write(10);
                    cnt = 0;
                }
                ++x;
            }
            ++k;
        }
        if (cnt > 0) {
            bab.write(10);
        }
    }

    private int imageDataSize() {
        int size = 0;
        int k = 0;
        while (k < this.imageData.length) {
            size += this.imageData[k].length;
            ++k;
        }
        return size;
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        if (this.topLevelElement) {
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            switch (this.alignment) {
                case 0: {
                    result.write(RtfParagraphStyle.ALIGN_LEFT);
                    break;
                }
                case 2: {
                    result.write(RtfParagraphStyle.ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    result.write(RtfParagraphStyle.ALIGN_CENTER);
                    break;
                }
                case 3: {
                    result.write(RtfParagraphStyle.ALIGN_JUSTIFY);
                }
            }
        }
        result.write(OPEN_GROUP);
        result.write(PICTURE_GROUP);
        result.write(OPEN_GROUP);
        result.write(PICTURE);
        switch (this.imageType) {
            case 1: {
                result.write(PICTURE_JPEG);
                break;
            }
            case 2: 
            case 3: {
                result.write(PICTURE_PNG);
                break;
            }
            case 4: 
            case 6: {
                result.write(PICTURE_WMF);
            }
        }
        result.write(PICTURE_WIDTH);
        result.write(this.intToByteArray((int)this.width));
        result.write(PICTURE_HEIGHT);
        result.write(this.intToByteArray((int)this.height));
        if (this.document.getDocumentSettings().isWriteImageScalingInformation()) {
            result.write(PICTURE_SCALE_X);
            result.write(this.intToByteArray((int)(100.0f * this.plainWidth / this.width)));
            result.write(PICTURE_SCALE_Y);
            result.write(this.intToByteArray((int)(100.0f * this.plainHeight / this.height)));
        }
        if (this.document.getDocumentSettings().isImagePDFConformance()) {
            result.write(PICTURE_SCALED_WIDTH);
            result.write(this.intToByteArray((int)((double)this.plainWidth * 20.0)));
            result.write(PICTURE_SCALED_HEIGHT);
            result.write(this.intToByteArray((int)((double)this.plainHeight * 20.0)));
        } else {
            if (this.width != this.plainWidth || this.imageType == 4) {
                result.write(PICTURE_SCALED_WIDTH);
                result.write(this.intToByteArray((int)(this.plainWidth * 15.0f)));
            }
            if (this.height != this.plainHeight || this.imageType == 4) {
                result.write(PICTURE_SCALED_HEIGHT);
                result.write(this.intToByteArray((int)(this.plainHeight * 15.0f)));
            }
        }
        if (this.document.getDocumentSettings().isImageWrittenAsBinary()) {
            result.write(10);
            result.write(PICTURE_BINARY_DATA);
            result.write(this.intToByteArray(this.imageDataSize()));
            result.write(DELIMITER);
            if (result instanceof RtfByteArrayBuffer) {
                ((RtfByteArrayBuffer)result).append(this.imageData);
            } else {
                int k = 0;
                while (k < this.imageData.length) {
                    result.write(this.imageData[k]);
                    ++k;
                }
            }
        } else {
            result.write(DELIMITER);
            result.write(10);
            this.writeImageDataHexEncoded(result);
        }
        result.write(CLOSE_GROUP);
        result.write(CLOSE_GROUP);
        if (this.topLevelElement) {
            result.write(RtfParagraph.PARAGRAPH);
            result.write(RtfParagraph.PARAGRAPH);
        }
        result.write(10);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setTopLevelElement(boolean topLevelElement) {
        this.topLevelElement = topLevelElement;
    }
}

