/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfProtection;
import com.lowagie.text.rtf.style.RtfParagraphStyle;

public class RtfDocumentSettings {
    private RtfDocument document = null;
    private boolean outputTableRowDefinitionAfter = true;
    private boolean outputDebugLineBreaks = false;
    private boolean alwaysGenerateSoftLinebreaks = false;
    private boolean alwaysUseUnicode = true;
    private int dataCacheStyle = 2;
    private boolean writeImageScalingInformation = false;
    private boolean imagePDFConformance = true;
    private int protectionLevel = 0;
    private String protectionHash = null;
    private String writereservhash = null;
    private boolean readOnlyRecommended = false;
    private boolean imageWrittenAsBinary = true;

    public RtfDocumentSettings(RtfDocument document) {
        this.document = document;
    }

    public boolean isOutputDebugLineBreaks() {
        return this.outputDebugLineBreaks;
    }

    public void setOutputDebugLineBreaks(boolean outputDebugLineBreaks) {
        this.outputDebugLineBreaks = outputDebugLineBreaks;
    }

    public boolean isOutputTableRowDefinitionAfter() {
        return this.outputTableRowDefinitionAfter;
    }

    public void setOutputTableRowDefinitionAfter(boolean outputTableRowDefinitionAfter) {
        this.outputTableRowDefinitionAfter = outputTableRowDefinitionAfter;
    }

    public boolean isAlwaysGenerateSoftLinebreaks() {
        return this.alwaysGenerateSoftLinebreaks;
    }

    public void setAlwaysGenerateSoftLinebreaks(boolean alwaysGenerateSoftLinebreaks) {
        this.alwaysGenerateSoftLinebreaks = alwaysGenerateSoftLinebreaks;
    }

    public boolean isAlwaysUseUnicode() {
        return this.alwaysUseUnicode;
    }

    public void setAlwaysUseUnicode(boolean alwaysUseUnicode) {
        this.alwaysUseUnicode = alwaysUseUnicode;
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        this.document.getDocumentHeader().registerParagraphStyle(rtfParagraphStyle);
    }

    public void setDataCacheStyle(int dataCacheStyle) {
        switch (dataCacheStyle) {
            case 3: {
                this.dataCacheStyle = 3;
                break;
            }
            case 1: {
                this.dataCacheStyle = 1;
                break;
            }
            default: {
                this.dataCacheStyle = 2;
            }
        }
    }

    public int getDataCacheStyle() {
        return this.dataCacheStyle;
    }

    public boolean isImagePDFConformance() {
        return this.imagePDFConformance;
    }

    public void setImagePDFConformance(boolean imagePDFConformance) {
        this.imagePDFConformance = imagePDFConformance;
    }

    public boolean isWriteImageScalingInformation() {
        return this.writeImageScalingInformation;
    }

    public void setWriteImageScalingInformation(boolean writeImageScalingInformation) {
        this.writeImageScalingInformation = writeImageScalingInformation;
    }

    public void setOptionsForMSWord2000And97() {
        this.setOutputTableRowDefinitionAfter(true);
        this.setWriteImageScalingInformation(true);
    }

    public void setOptionsForMSWordForMac() {
        this.setWriteImageScalingInformation(true);
    }

    public void setOptionsForMSWordXP() {
        this.setWriteImageScalingInformation(false);
    }

    public void setOptionsForOpenOfficeOrg() {
        this.setOutputTableRowDefinitionAfter(false);
    }

    public boolean setProtection(int level, String pwd) {
        boolean result = false;
        if (this.protectionHash == null) {
            if (!this.setProtectionLevel(level)) {
                result = false;
            } else {
                this.protectionHash = RtfProtection.generateHash(pwd);
                result = true;
            }
        } else if (this.protectionHash.equals(RtfProtection.generateHash(pwd))) {
            if (!this.setProtectionLevel(level)) {
                result = false;
            } else {
                this.protectionHash = RtfProtection.generateHash(pwd);
                result = true;
            }
        }
        return result;
    }

    public boolean unprotectDocument(String pwd) {
        boolean result = false;
        if (this.protectionHash.equals(RtfProtection.generateHash(pwd))) {
            this.protectionLevel = 0;
            this.protectionHash = null;
            result = true;
        }
        return result;
    }

    public boolean setProtectionLevel(int level) {
        boolean result = false;
        switch (level) {
            case 0: {
                if (this.protectionHash == null) break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.protectionLevel = level;
                result = true;
            }
        }
        return result;
    }

    public void setPasswordHash(String pwd) {
        if (pwd != null && pwd.length() != 8) {
            return;
        }
        this.protectionHash = pwd;
    }

    private int convertProtectionLevel() {
        int level = 0;
        switch (this.protectionLevel) {
            case 0: {
                break;
            }
            case 1: {
                level = 0;
                break;
            }
            case 2: {
                level = 1;
                break;
            }
            case 4: {
                level = 2;
                break;
            }
            case 8: {
                level = 3;
            }
        }
        return level;
    }

    public int getProtectionLevelRaw() {
        return this.protectionLevel;
    }

    public int getProtectionLevel() {
        return this.convertProtectionLevel();
    }

    public byte[] getProtectionLevelBytes() {
        return DocWriter.getISOBytes(Integer.toString(this.convertProtectionLevel()));
    }

    public boolean setNewPassword(String oldPwd, String newPwd) {
        boolean result = false;
        if (this.protectionHash.equals(RtfProtection.generateHash(oldPwd))) {
            this.protectionHash = RtfProtection.generateHash(newPwd);
            result = true;
        }
        return result;
    }

    public void setReadOnlyRecommended(boolean value) {
        this.readOnlyRecommended = value;
    }

    public boolean getReadOnlyRecommended() {
        return this.readOnlyRecommended;
    }

    public boolean isDocumentProtected() {
        return this.protectionHash != null;
    }

    public byte[] getProtectionHashBytes() {
        return DocWriter.getISOBytes(this.protectionHash);
    }

    public void setImageWrittenAsBinary(boolean imageWrittenAsBinary) {
        this.imageWrittenAsBinary = imageWrittenAsBinary;
    }

    public boolean isImageWrittenAsBinary() {
        return this.imageWrittenAsBinary;
    }
}

