/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfCodePage;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfGenerator;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.document.RtfInfoGroup;
import com.lowagie.text.rtf.document.RtfPageSetting;
import com.lowagie.text.rtf.document.RtfProtectionSetting;
import com.lowagie.text.rtf.document.output.RtfNilOutputStream;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooterGroup;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfListTable;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfColorList;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.style.RtfStylesheetList;
import java.io.IOException;
import java.io.OutputStream;

public class RtfDocumentHeader
extends RtfElement {
    private static final byte[] TITLE_PAGE = DocWriter.getISOBytes("\\titlepg");
    private static final byte[] FACING_PAGES = DocWriter.getISOBytes("\\facingp");
    private RtfCodePage codePage = null;
    private RtfColorList colorList = null;
    private RtfFontList fontList = null;
    private RtfListTable listTable = null;
    private RtfStylesheetList stylesheetList = null;
    private RtfGenerator generator = null;
    private RtfInfoGroup infoGroup = null;
    private RtfProtectionSetting protectionSetting = null;
    private RtfPageSetting pageSetting = null;
    private HeaderFooter header = null;
    private HeaderFooter footer = null;

    protected RtfDocumentHeader(RtfDocument doc) {
        super(doc);
    }

    protected void init() {
        this.codePage = new RtfCodePage(this.document);
        this.colorList = new RtfColorList(this.document);
        this.fontList = new RtfFontList(this.document);
        this.listTable = new RtfListTable(this.document);
        this.stylesheetList = new RtfStylesheetList(this.document);
        this.infoGroup = new RtfInfoGroup(this.document);
        this.protectionSetting = new RtfProtectionSetting(this.document);
        this.pageSetting = new RtfPageSetting(this.document);
        this.header = new RtfHeaderFooterGroup(this.document, 1);
        this.footer = new RtfHeaderFooterGroup(this.document, 2);
        this.generator = new RtfGenerator(this.document);
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        try {
            this.writeSectionDefinition(new RtfNilOutputStream());
            this.codePage.writeDefinition(result);
            this.fontList.writeDefinition(result);
            this.colorList.writeDefinition(result);
            this.stylesheetList.writeDefinition(result);
            this.listTable.writeDefinition(result);
            this.generator.writeContent(result);
            this.infoGroup.writeContent(result);
            this.protectionSetting.writeDefinition(result);
            this.pageSetting.writeDefinition(result);
            this.writeSectionDefinition(result);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void writeSectionDefinition(OutputStream result) {
        try {
            RtfHeaderFooterGroup header = this.convertHeaderFooter(this.header, 1);
            RtfHeaderFooterGroup footer = this.convertHeaderFooter(this.footer, 2);
            if (header.hasTitlePage() || footer.hasTitlePage()) {
                result.write(TITLE_PAGE);
                header.setHasTitlePage();
                footer.setHasTitlePage();
            }
            if (header.hasFacingPages() || footer.hasFacingPages()) {
                result.write(FACING_PAGES);
                header.setHasFacingPages();
                footer.setHasFacingPages();
            }
            footer.writeContent(result);
            header.writeContent(result);
            this.pageSetting.writeSectionDefinition(result);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public int getFontNumber(RtfFont font) {
        return this.fontList.getFontNumber(font);
    }

    public int getColorNumber(RtfColor color) {
        return this.colorList.getColorNumber(color);
    }

    public int getListNumber(RtfList list) {
        return this.listTable.getListNumber(list);
    }

    public RtfParagraphStyle getRtfParagraphStyle(String styleName) {
        return this.stylesheetList.getRtfParagraphStyle(styleName);
    }

    public void freeListNumber(RtfList list) {
        this.listTable.freeListNumber(list);
    }

    public RtfPageSetting getPageSetting() {
        return this.pageSetting;
    }

    public void addInfoElement(RtfInfoElement rtfInfoElement) {
        this.infoGroup.add(rtfInfoElement);
    }

    public void setHeader(HeaderFooter header) {
        this.header = header;
    }

    public void setFooter(HeaderFooter footer) {
        this.footer = footer;
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        this.stylesheetList.registerParagraphStyle(rtfParagraphStyle);
    }

    private RtfHeaderFooterGroup convertHeaderFooter(HeaderFooter hf, int type) {
        if (hf != null) {
            if (hf instanceof RtfHeaderFooterGroup) {
                return new RtfHeaderFooterGroup(this.document, (RtfHeaderFooterGroup)hf, type);
            }
            if (hf instanceof RtfHeaderFooter) {
                return new RtfHeaderFooterGroup(this.document, (RtfHeaderFooter)hf, type);
            }
            return new RtfHeaderFooterGroup(this.document, hf, type);
        }
        return new RtfHeaderFooterGroup(this.document, type);
    }

    public RtfListTable getListTable() {
        return this.listTable;
    }
}

