/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridFooterRenderer;
import org.eclipse.nebula.widgets.grid.GridHeaderEditor;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.DefaultCellRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultColumnFooterRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultColumnHeaderRenderer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class GridColumn
extends Item {
    private GridHeaderEditor controlEditor;
    private static final int DEFAULT_WIDTH = 10;
    private Grid parent;
    private GridHeaderRenderer headerRenderer = new DefaultColumnHeaderRenderer();
    private GridFooterRenderer footerRenderer = new DefaultColumnFooterRenderer();
    private GridCellRenderer cellRenderer = new DefaultCellRenderer();
    private int width = 10;
    private int sortStyle = 0;
    private boolean tree = false;
    private boolean check = false;
    private boolean tableCheck = false;
    private boolean resizeable = true;
    private boolean moveable = false;
    private boolean summary = true;
    private boolean detail = true;
    private boolean visible = true;
    private boolean cellSelectionEnabled = true;
    private GridColumnGroup group;
    private boolean checkable = true;
    private Image footerImage;
    private String footerText = "";
    private Font headerFont;
    private Font footerFont;
    private int minimumWidth = 0;
    private String headerTooltip = null;

    public GridColumn(Grid parent, int style) {
        this(parent, style, -1);
    }

    public GridColumn(Grid parent, int style, int index) {
        super((Widget)parent, style, index);
        this.init(parent, style, index);
    }

    public GridColumn(GridColumnGroup parent, int style) {
        super((Widget)parent.getParent(), style, parent.getNewColumnIndex());
        this.init(parent.getParent(), style, parent.getNewColumnIndex());
        this.group = parent;
        this.group.newColumn(this, -1);
    }

    private void init(Grid table, int style, int index) {
        this.parent = table;
        table.newColumn(this, index);
        if ((style & 0x20) == 32) {
            this.check = true;
        }
        this.initHeaderRenderer();
        this.initFooterRenderer();
        this.initCellRenderer();
    }

    public void dispose() {
        if (!this.parent.isDisposing()) {
            this.parent.removeColumn(this);
            if (this.group != null) {
                this.group.removeColumn(this);
            }
            if (this.controlEditor != null) {
                this.controlEditor.dispose();
            }
        }
        super.dispose();
    }

    private void initHeaderRenderer() {
        this.headerRenderer.setDisplay(this.getDisplay());
    }

    private void initFooterRenderer() {
        this.footerRenderer.setDisplay(this.getDisplay());
    }

    private void initCellRenderer() {
        this.cellRenderer.setDisplay(this.getDisplay());
        this.cellRenderer.setCheck(this.check);
        this.cellRenderer.setTree(this.tree);
        this.cellRenderer.setColumn(this.parent.indexOf(this));
        if ((this.getStyle() & 0x20000) == 131072) {
            this.cellRenderer.setAlignment(131072);
        }
        if ((this.getStyle() & 0x1000000) == 0x1000000) {
            this.cellRenderer.setAlignment(0x1000000);
        }
    }

    public GridHeaderRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    GridFooterRenderer getFooterRenderer() {
        return this.footerRenderer;
    }

    public GridCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.setWidth(width, true);
    }

    void setWidth(int width, boolean redraw) {
        this.width = Math.max(this.minimumWidth, width);
        if (redraw) {
            this.parent.setScrollValuesObsolete();
            this.parent.redraw();
        }
    }

    public void setSort(int style) {
        this.checkWidget();
        this.sortStyle = style;
        this.parent.redraw();
    }

    public int getSort() {
        this.checkWidget();
        return this.sortStyle;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)listener));
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.removeListener(13, (SWTEventListener)listener);
    }

    void fireListeners() {
        Event e = new Event();
        e.display = this.getDisplay();
        e.item = this;
        e.widget = this.parent;
        this.notifyListeners(13, e);
    }

    public boolean isVisible() {
        this.checkWidget();
        if (this.group != null && (this.group.getExpanded() && !this.isDetail() || !this.group.getExpanded() && !this.isSummary())) {
            return false;
        }
        return this.visible;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        boolean before = this.isVisible();
        this.visible = visible;
        if (this.isVisible() != before) {
            if (visible) {
                this.notifyListeners(22, new Event());
            } else {
                this.notifyListeners(23, new Event());
            }
            GridColumn[] colsOrdered = this.parent.getColumnsInOrder();
            int i = 0;
            while (i < colsOrdered.length) {
                GridColumn column = colsOrdered[i];
                if (column != this && column.isVisible()) {
                    column.fireMoved();
                }
                ++i;
            }
            this.parent.redraw();
        }
    }

    public void pack() {
        this.checkWidget();
        GC gc = new GC((Drawable)this.parent);
        int newWidth = this.getHeaderRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)this)).x;
        GridItem[] items = this.parent.getItems();
        int i = 0;
        while (i < items.length) {
            GridItem item = items[i];
            if (item.isVisible()) {
                this.getCellRenderer().setColumn(this.parent.indexOf(this));
                newWidth = Math.max(newWidth, this.getCellRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)item)).x);
            }
            ++i;
        }
        gc.dispose();
        this.setWidth(newWidth);
        this.parent.redraw();
    }

    public boolean isTree() {
        this.checkWidget();
        return this.tree;
    }

    public boolean isCheck() {
        this.checkWidget();
        return this.check || this.tableCheck;
    }

    public void setCellRenderer(GridCellRenderer cellRenderer) {
        this.checkWidget();
        this.cellRenderer = cellRenderer;
        this.initCellRenderer();
    }

    public void setHeaderRenderer(GridHeaderRenderer headerRenderer) {
        this.checkWidget();
        this.headerRenderer = headerRenderer;
        this.initHeaderRenderer();
    }

    public void setFooterRenderer(GridFooterRenderer footerRenderer) {
        this.checkWidget();
        this.footerRenderer = footerRenderer;
        this.initFooterRenderer();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(11, (Listener)typedListener);
        this.addListener(10, (Listener)typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(11, (SWTEventListener)listener);
        this.removeListener(10, (SWTEventListener)listener);
    }

    void fireMoved() {
        Event e = new Event();
        e.display = this.getDisplay();
        e.item = this;
        e.widget = this.parent;
        this.notifyListeners(10, e);
    }

    void fireResized() {
        Event e = new Event();
        e.display = this.getDisplay();
        e.item = this;
        e.widget = this.parent;
        this.notifyListeners(11, e);
    }

    public void setTree(boolean tree) {
        this.checkWidget();
        this.tree = tree;
        this.cellRenderer.setTree(tree);
        this.parent.redraw();
    }

    public int getAlignment() {
        this.checkWidget();
        return this.cellRenderer.getAlignment();
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        this.cellRenderer.setAlignment(alignment);
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
        this.parent.redraw();
    }

    public boolean getResizeable() {
        this.checkWidget();
        return this.resizeable;
    }

    public void setResizeable(boolean resizeable) {
        this.checkWidget();
        this.resizeable = resizeable;
    }

    public GridColumnGroup getColumnGroup() {
        this.checkWidget();
        return this.group;
    }

    public boolean isDetail() {
        this.checkWidget();
        return this.detail;
    }

    public void setDetail(boolean detail) {
        this.checkWidget();
        this.detail = detail;
    }

    public boolean isSummary() {
        this.checkWidget();
        return this.summary;
    }

    public void setSummary(boolean summary) {
        this.checkWidget();
        this.summary = summary;
    }

    Rectangle getBounds() {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        if (!this.isVisible()) {
            return bounds;
        }
        Point loc = this.parent.getOrigin(this, null);
        bounds.x = loc.x;
        bounds.y = loc.y;
        bounds.width = this.getWidth();
        bounds.height = this.parent.getHeaderHeight();
        if (this.getColumnGroup() != null) {
            bounds.height -= this.parent.getGroupHeaderHeight();
        }
        return bounds;
    }

    protected boolean isTableCheck() {
        return this.tableCheck;
    }

    protected void setTableCheck(boolean tableCheck) {
        this.tableCheck = tableCheck;
        this.cellRenderer.setCheck(tableCheck || this.check);
    }

    public boolean getCellSelectionEnabled() {
        this.checkWidget();
        return this.cellSelectionEnabled;
    }

    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        this.checkWidget();
        this.cellSelectionEnabled = cellSelectionEnabled;
    }

    public Grid getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getCheckable() {
        this.checkWidget();
        return this.checkable;
    }

    public void setCheckable(boolean checkable) {
        this.checkWidget();
        this.checkable = checkable;
    }

    void setColumnIndex(int newIndex) {
        this.cellRenderer.setColumn(newIndex);
    }

    public boolean getWordWrap() {
        this.checkWidget();
        return this.cellRenderer.isWordWrap();
    }

    public void setWordWrap(boolean wordWrap) {
        this.checkWidget();
        this.cellRenderer.setWordWrap(wordWrap);
        this.parent.redraw();
    }

    public void setHeaderWordWrap(boolean wordWrap) {
        this.checkWidget();
        this.headerRenderer.setWordWrap(wordWrap);
        this.parent.redraw();
    }

    public boolean getHeaderWordWrap() {
        this.checkWidget();
        return this.headerRenderer.isWordWrap();
    }

    public void setHeaderControl(Control control) {
        if (this.controlEditor == null) {
            this.controlEditor = new GridHeaderEditor(this);
            this.controlEditor.initColumn();
        }
        this.controlEditor.setEditor(control);
        this.getParent().recalculateHeader();
        if (control != null) {
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GridColumn.this.controlEditor != null && GridColumn.this.controlEditor.getEditor() != null) {
                        GridColumn.this.controlEditor.layout();
                    }
                }
            });
        }
    }

    public Control getHeaderControl() {
        if (this.controlEditor != null) {
            return this.controlEditor.getEditor();
        }
        return null;
    }

    public String getHeaderTooltip() {
        this.checkWidget();
        return this.headerTooltip;
    }

    public void setHeaderTooltip(String tooltip) {
        this.checkWidget();
        this.headerTooltip = tooltip;
    }

    public void setFooterImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error((int)5);
        }
        this.footerImage = image;
    }

    public void setFooterText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.footerText = string;
    }

    public Image getFooterImage() {
        this.checkWidget();
        return this.footerImage;
    }

    public String getFooterText() {
        this.checkWidget();
        return this.footerText;
    }

    public Font getHeaderFont() {
        this.checkWidget();
        if (this.headerFont == null) {
            return this.parent.getFont();
        }
        return this.headerFont;
    }

    public void setHeaderFont(Font font) {
        this.checkWidget();
        this.headerFont = font;
    }

    public Font getFooterFont() {
        this.checkWidget();
        if (this.footerFont == null) {
            return this.parent.getFont();
        }
        return this.footerFont;
    }

    public void setFooterFont(Font font) {
        this.checkWidget();
        this.footerFont = font;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = Math.max(0, minimumWidth);
        if (minimumWidth > this.getWidth()) {
            this.setWidth(minimumWidth, true);
        }
    }
}

