/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.refactoring;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.PathChild;
import org.simantics.graph.refactoring.GraphRefactoringException;
import org.simantics.graph.refactoring.MappingSpecification;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.old.OldTransferableGraph1;
import org.simantics.graph.representation.old.OldValue1;
import org.simantics.graph.store.IdentityStore;

public class GraphRefactoringUtils {
    public static boolean moveExternal(TransferableGraph1 tg, IdentityStore ids, Path from, PathChild to, TIntHashSet parentsAffected) throws GraphRefactoringException {
        int toParentId;
        int fromId = ids.pathToId(from);
        if (fromId < 0) {
            return false;
        }
        if (ids.isNewResource(fromId)) {
            throw new GraphRefactoringException("Cannot move internal resource " + from + ".");
        }
        int parentId = ids.removeIdentity(fromId);
        if (parentId >= 0) {
            parentsAffected.add(parentId);
        }
        if (ids.hasChild(toParentId = ids.createPathToId(to.parent), to.name)) {
            System.err.println("refactor statements from " + from + " to " + to);
            int toId = ids.pathToId(to);
            int[] statements = tg.statements;
            int i = 0;
            while (i < tg.statements.length) {
                if (statements[i] == fromId) {
                    statements[i] = toId;
                }
                ++i;
            }
            return true;
        }
        ids.setIdentity(fromId, toParentId, to.name);
        return true;
    }

    public static void refactor(TransferableGraph1 tg, IdentityStore ids, MappingSpecification spec, TIntHashSet parentsAffected) throws GraphRefactoringException {
        for (MappingSpecification.MappingRule rule : spec.getRules()) {
            if (!(rule.to instanceof PathChild)) {
                throw new GraphRefactoringException("Invalid target URI " + rule.to);
            }
            if (GraphRefactoringUtils.moveExternal(tg, ids, rule.from, (PathChild)rule.to, parentsAffected)) continue;
            System.err.println("Didn't find " + rule.from);
        }
    }

    public static boolean fixIncorrectRoot(Identity[] ids) {
        int i = 0;
        while (i < ids.length) {
            Identity id = ids[i];
            if (id.definition instanceof External) {
                External ext = (External)id.definition;
                if (ext.parent == -1 && (ext.name.equals("http:/") || ext.name.equals(""))) {
                    id.definition = new Root("", "");
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static void unfixIncorrectRoot(Identity[] ids) {
        int i = 0;
        while (i < ids.length) {
            Identity id = ids[i];
            if (id.definition instanceof Root) {
                Root root = (Root)id.definition;
                if (root.name.equals("") && root.type.equals("")) {
                    id.definition = new External(-1, "http:/");
                    return;
                }
            }
            ++i;
        }
    }

    public static void compactify(OldTransferableGraph1 tg, TIntHashSet removed) {
        Object[] objectArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = objectArray[n2];
            IdentityDefinition def = id.definition;
            if (def instanceof Root) {
                removed.remove(id.resource);
            } else if (def instanceof External) {
                removed.remove(((External)def).parent);
            } else if (def instanceof Internal) {
                removed.remove(((Internal)def).parent);
            } else if (def instanceof Optional) {
                removed.remove(((Optional)def).parent);
            }
            ++n2;
        }
        objectArray = tg.statements;
        n = tg.statements.length;
        n2 = 0;
        while (n2 < n) {
            Identity r = objectArray[n2];
            removed.remove((int)r);
            ++n2;
        }
        objectArray = tg.values;
        n = tg.values.length;
        n2 = 0;
        while (n2 < n) {
            Identity value = objectArray[n2];
            removed.remove(((OldValue1)((Object)value)).resource);
            ++n2;
        }
        if (!removed.isEmpty()) {
            int resourceCount = tg.resourceCount;
            int[] map = new int[resourceCount];
            int i = 0;
            while (i < resourceCount) {
                map[i] = i;
                ++i;
            }
            int[] nArray = removed.toArray();
            int def = nArray.length;
            int n3 = 0;
            while (n3 < def) {
                int r = nArray[n3];
                map[--resourceCount] = map[r];
                ++n3;
            }
            ArrayList<Identity> newIdentities = new ArrayList<Identity>(tg.identities.length);
            Identity[] identityArray = tg.identities;
            int n4 = tg.identities.length;
            def = 0;
            while (def < n4) {
                Identity id = identityArray[def];
                if (!removed.contains(id.resource)) {
                    External d;
                    newIdentities.add(id);
                    id.resource = map[id.resource];
                    IdentityDefinition def2 = id.definition;
                    if (def2 instanceof External) {
                        d = (External)def2;
                        d.parent = map[d.parent];
                    } else if (def2 instanceof Internal) {
                        d = (External)def2;
                        d.parent = map[d.parent];
                    } else if (def2 instanceof Optional) {
                        d = (External)def2;
                        d.parent = map[d.parent];
                    }
                }
                ++def;
            }
            tg.identities = newIdentities.toArray(new Identity[newIdentities.size()]);
            int[] statements = tg.statements;
            int i2 = 0;
            while (i2 < statements.length) {
                int r = statements[i2];
                if (r >= 0) {
                    statements[i2] = map[r];
                }
                ++i2;
            }
            OldValue1[] oldValue1Array = tg.values;
            int n5 = tg.values.length;
            n4 = 0;
            while (n4 < n5) {
                OldValue1 value = oldValue1Array[n4];
                value.resource = map[value.resource];
                ++n4;
            }
            tg.resourceCount = resourceCount;
        }
    }
}

