/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets.impl;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Text;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Write;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.ui.ISelectionUtils;

public abstract class TextModifyListenerImpl<T>
implements TextModifyListener,
Widget {
    protected ISessionContext context;
    protected Object lastInput = null;
    protected final Class<?> clazz = ReflectionUtils.getSingleParameterType(this.getClass());

    private Object getInputContents(Object input, Class<?> inputClass) {
        if (inputClass.isInstance(input)) {
            return input;
        }
        if (input instanceof ISelection) {
            return ISelectionUtils.filterSingleSelection((Object)input, inputClass);
        }
        return null;
    }

    @Override
    public void modifyText(TrackedModifyEvent e) {
        Text text = (Text)e.getWidget();
        final String textValue = text.getText();
        final Object input = this.lastInput;
        try {
            this.context.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    if (TextModifyListenerImpl.this.clazz.isInstance(input)) {
                        TextModifyListenerImpl.this.applyText(graph, input, textValue);
                        Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Modified " + input.toString() + " to " + textValue));
                    } else {
                        Object single = TextModifyListenerImpl.this.getInputContents(input, TextModifyListenerImpl.this.clazz);
                        if (single != null) {
                            TextModifyListenerImpl.this.applyText(graph, single, textValue);
                            Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Modified " + single.toString() + " to " + textValue));
                        }
                    }
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void setInput(ISessionContext context, Object parameter) {
        this.context = context;
        this.lastInput = parameter;
    }

    public abstract void applyText(WriteGraph var1, T var2, String var3) throws DatabaseException;
}

