/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets.impl;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ISelectionUtils;

public abstract class ReadFactoryImpl<Input, Output>
implements ReadFactory<Input, Output> {
    final Class<?> inputClass = ReflectionUtils.getSingleParameterType(this.getClass());

    protected ReadFactoryImpl() {
    }

    public Object getIdentity(Object inputContents) {
        return new Pair(inputContents, this.getClass());
    }

    private Object getInputContents(Object input, Class<?> inputClass) {
        if (inputClass.isInstance(input)) {
            return input;
        }
        if (input instanceof ISelection) {
            return ISelectionUtils.filterSingleSelection((Object)input, inputClass);
        }
        return null;
    }

    @Override
    public void listen(ISessionContext context, Object input, Listener<Output> listener) {
        final Object inputContents = this.getInputContents(input, this.inputClass);
        if (inputContents != null) {
            context.getSession().asyncRequest((Read)new UnaryRead<Object, Output>(this.getIdentity(inputContents)){

                public Output perform(ReadGraph graph) throws DatabaseException {
                    return ReadFactoryImpl.this.perform(graph, inputContents);
                }

                public String toString() {
                    return ReadFactoryImpl.this.getIdentity(inputContents).toString();
                }
            }, listener);
        }
    }

    public abstract Output perform(ReadGraph var1, Input var2) throws DatabaseException;
}

