/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;

public class StringPropertyModifier
extends TextModifyListenerImpl<Resource> {
    private final String propertyURI;
    private final boolean undo;

    public StringPropertyModifier(ISessionContext context, String propertyURI) {
        this(context, propertyURI, true);
    }

    public StringPropertyModifier(ISessionContext context, String propertyURI, boolean undo) {
        this.propertyURI = propertyURI;
        this.undo = undo;
    }

    @Override
    public void applyText(WriteGraph graph, Resource issue, String text) throws DatabaseException {
        if (this.undo) {
            String meta = this.propertyURI;
            int i = this.propertyURI.lastIndexOf("/");
            if (i > 0) {
                meta = meta.substring(i + 1);
            }
            Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Modify String " + meta));
            graph.markUndoPoint();
        }
        graph.claimLiteral(issue, graph.getResource(this.propertyURI), (Object)text, (Binding)Bindings.STRING);
    }
}

