/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.simantics.browsing.ui.swt.widgets.WidgetImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.scl.compiler.StandardSCLCompilerConfiguration;
import org.simantics.scl.ui.editor.SCLTextEditor;
import org.simantics.utils.ui.SWTUtils;

public class SCLEditor
extends WidgetImpl {
    private ReadFactory<?, String> textFactory;
    private final SCLTextEditor editor;

    public SCLEditor(Composite parent, WidgetSupport support, int style) {
        super(support);
        this.editor = new SCLTextEditor(parent, style, StandardSCLCompilerConfiguration.INSTANCE);
        support.register(this);
    }

    public void setTextFactory(ReadFactory<?, String> textFactory) {
        this.textFactory = textFactory;
    }

    public SCLTextEditor getWidget() {
        return this.editor;
    }

    @Override
    public Control getControl() {
        return this.editor;
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        if (this.textFactory != null) {
            this.textFactory.listen(context, input, new Listener<String>(){

                public void exception(final Throwable t) {
                    SWTUtils.asyncExec((Widget)SCLEditor.this.editor, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            SCLEditor.this.editor.setContent(t.toString());
                        }
                    });
                }

                public void execute(final String s) {
                    SWTUtils.asyncExec((Widget)SCLEditor.this.editor, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            SCLEditor.this.editor.setContent(s);
                        }
                    });
                }

                public boolean isDisposed() {
                    return SCLEditor.this.editor.isDisposed();
                }
            });
        }
    }

    public void setContent(String s) {
        this.editor.setContent(s);
    }

    public String getContent() {
        return this.editor.getContent();
    }
}

