/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.swt.widgets.WidgetImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ReadInterface;
import org.simantics.utils.ui.SWTUtils;

public class Button
extends WidgetImpl {
    private ReadFactory<?, String> textFactory;
    private ReadFactory<?, String> tooltipFactory;
    private ReadFactory<?, ImageDescriptor> imageFactory;
    private ReadFactory<?, Boolean> selectionFactory;
    private CopyOnWriteArrayList<SelectionListener> selectionListeners = new CopyOnWriteArrayList();
    private final org.eclipse.swt.widgets.Button button;

    public Button(Composite parent, WidgetSupport support, int style) {
        super(support);
        this.button = new org.eclipse.swt.widgets.Button(parent, style);
        support.register(this);
    }

    public void setTextFactory(ReadFactory<?, String> textFactory) {
        this.textFactory = textFactory;
    }

    public void setTooltipFactory(ReadFactory<?, String> tooltipFactory) {
        this.tooltipFactory = tooltipFactory;
    }

    public void setImageFactory(ReadFactory<?, ImageDescriptor> imageFactory) {
        this.imageFactory = imageFactory;
    }

    public void setSelectionFactory(ReadFactory<?, Boolean> selectionFactory) {
        this.selectionFactory = selectionFactory;
    }

    public org.eclipse.swt.widgets.Button getWidget() {
        return this.button;
    }

    @Override
    public Control getControl() {
        return this.button;
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        if (this.selectionListeners != null) {
            for (SelectionListener listener : this.selectionListeners) {
                if (!(listener instanceof Widget)) continue;
                ((Widget)listener).setInput(context, input);
            }
        }
        if (this.textFactory != null) {
            this.textFactory.listen(context, input, new Listener<String>(){

                public void exception(final Throwable t) {
                    SWTUtils.asyncExec((org.eclipse.swt.widgets.Widget)Button.this.button, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            Button.this.button.setText(t.toString());
                        }
                    });
                }

                public void execute(final String text) {
                    SWTUtils.asyncExec((org.eclipse.swt.widgets.Widget)Button.this.button, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            Button.this.button.setText(text);
                        }
                    });
                }

                public boolean isDisposed() {
                    return Button.this.button.isDisposed();
                }
            });
        }
        if (this.tooltipFactory != null) {
            this.tooltipFactory.listen(context, input, new Listener<String>(){

                public void exception(Throwable t) {
                    ErrorLogger.defaultLogError((Throwable)t);
                }

                public void execute(final String text) {
                    SWTUtils.asyncExec((org.eclipse.swt.widgets.Widget)Button.this.button, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            Button.this.button.setToolTipText(text);
                        }
                    });
                }

                public boolean isDisposed() {
                    return Button.this.button.isDisposed();
                }
            });
        }
        if (this.imageFactory != null) {
            this.imageFactory.listen(context, input, new Listener<ImageDescriptor>(){

                public void exception(Throwable t) {
                    ErrorLogger.defaultLogError((Throwable)t);
                }

                public void execute(final ImageDescriptor imageDescriptor) {
                    SWTUtils.asyncExec((org.eclipse.swt.widgets.Widget)Button.this.button, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            ResourceManager rm = (ResourceManager)(this).Button.this.support.getParameter("resourceManager");
                            if (rm != null) {
                                Image image = (Image)rm.get((DeviceResourceDescriptor)imageDescriptor);
                                Button.this.button.setImage(image);
                            }
                            Button.this.button.getParent().layout();
                            Button.this.button.getParent().getParent().layout();
                        }
                    });
                }

                public boolean isDisposed() {
                    return Button.this.button.isDisposed();
                }
            });
        }
        if (this.selectionFactory != null) {
            this.selectionFactory.listen(context, input, new Listener<Boolean>(){

                public void exception(Throwable t) {
                    ErrorLogger.defaultLogError((Throwable)t);
                }

                public void execute(final Boolean selected) {
                    SWTUtils.asyncExec((org.eclipse.swt.widgets.Widget)Button.this.button, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            Button.this.button.setSelection(selected.booleanValue());
                        }
                    });
                }

                public boolean isDisposed() {
                    return Button.this.button.isDisposed();
                }
            });
        }
    }

    public void setText(String text) {
        this.button.setText(text);
    }

    public <T> void setText(final ParametrizedRead<T, String> read) {
        Simantics.getSession().async((ReadInterface)new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Object input = Button.this.support.getInput(graph);
                return (String)graph.syncRequest(read.get(input));
            }
        }, (Listener)new Listener<String>(){

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public void execute(final String text) {
                if (this.isDisposed()) {
                    return;
                }
                Button.this.button.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Button.this.button.setText(text);
                    }
                });
            }

            public boolean isDisposed() {
                return Button.this.button.isDisposed();
            }
        });
    }

    public void setTooltipText(String text) {
        this.button.setToolTipText(text);
    }

    public void setImage(Image image) {
        this.button.setImage(image);
    }

    public void setSelection(boolean selected) {
        this.button.setSelection(selected);
    }

    public synchronized void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
        this.button.addSelectionListener(listener);
    }
}

