/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.contentassist;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeMap;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.simantics.browsing.ui.swt.contentassist.FindExactMatch;
import org.simantics.browsing.ui.swt.contentassist.INamedObject;
import org.simantics.browsing.ui.swt.contentassist.INamedObjectContentProposal;
import org.simantics.browsing.ui.swt.contentassist.NamedObjectContentProposalProvider;
import org.simantics.browsing.ui.swt.contentassist.OpenableContentAssistCommandAdapter;

public class ContentAssistTextField
extends Composite {
    private static final boolean DEBUG = false;
    Text text;
    INamedObject acceptedProposal;
    INamedObject result;
    OpenableContentAssistCommandAdapter contentAssist;

    public <T extends INamedObject> ContentAssistTextField(Composite parent, T initialValue, T[] allowedValues, int style) {
        this(parent, initialValue, Arrays.asList(allowedValues), style);
    }

    public <T extends INamedObject> ContentAssistTextField(final Composite parent, T initialValue, final Collection<T> allowedValues, int style) {
        super(parent, style);
        this.result = initialValue;
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.text = new Text((Composite)this, style);
        this.text.setText(initialValue == null ? "" : initialValue.getName());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.text);
        final TreeMap<String, INamedObject> valueMap = new TreeMap<String, INamedObject>(String.CASE_INSENSITIVE_ORDER);
        for (INamedObject t : allowedValues) {
            valueMap.put(t.getName(), t);
        }
        this.contentAssist = new OpenableContentAssistCommandAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), new NamedObjectContentProposalProvider<T>(allowedValues), null, null, true);
        this.contentAssist.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                ContentAssistTextField.this.result = ContentAssistTextField.this.acceptedProposal = ((INamedObjectContentProposal)proposal).getNamedObject();
                ContentAssistTextField.this.text.setText(ContentAssistTextField.this.acceptedProposal.getName());
                ContentAssistTextField.this.text.setSelection(ContentAssistTextField.this.acceptedProposal.getName().length());
            }
        });
        this.contentAssist.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                System.out.println("focus");
                super.focusGained(e);
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String t = ContentAssistTextField.this.text.getText();
                INamedObject obj = (INamedObject)valueMap.get(t);
                if (obj == null) {
                    ContentAssistTextField.this.result = null;
                    ContentAssistTextField.this.contentAssist.open();
                } else {
                    ContentAssistTextField.this.result = obj;
                }
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    String name = ContentAssistTextField.this.text.getText();
                    if (name.isEmpty()) {
                        return;
                    }
                    if (ContentAssistTextField.this.acceptedProposal == null) {
                        ContentAssistTextField.this.acceptedProposal = FindExactMatch.exec(name, allowedValues);
                    }
                    if (ContentAssistTextField.this.acceptedProposal == null) {
                        ContentAssistTextField.this.contentAssist.open();
                    } else {
                        ContentAssistTextField.this.result = ContentAssistTextField.this.acceptedProposal;
                    }
                }
            }
        });
        this.text.addFocusListener(new FocusListener(){
            TraverseListener listener = new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 4) {
                        e.doit = false;
                    }
                }
            };

            public void focusLost(FocusEvent e) {
                parent.removeTraverseListener(this.listener);
            }

            public void focusGained(FocusEvent e) {
                parent.addTraverseListener(this.listener);
            }
        });
        this.contentAssist.setPropagateKeys(true);
    }

    public INamedObject getResult() {
        return this.result;
    }

    public Text getControl() {
        return this.text;
    }

    public void openAssist() {
        this.contentAssist.open();
    }
}

