/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;

public class SingleClickStartEditMouseListener
extends MouseAdapter {
    public static final IFilter BUTTON1_FIRST_DOWN_FILTER = new IFilter(){

        public boolean select(Object toTest) {
            MouseEvent e = (MouseEvent)toTest;
            return e.button == 1 && e.count == 1;
        }
    };
    private GraphExplorer explorer;
    private IFilter eventFilter;
    private Tree tree;
    private Column[] columns;

    public static SingleClickStartEditMouseListener attachWithSingleLeftDown(GraphExplorer explorer) {
        return SingleClickStartEditMouseListener.attachTo(explorer, BUTTON1_FIRST_DOWN_FILTER);
    }

    public static SingleClickStartEditMouseListener attachTo(GraphExplorer explorer, IFilter eventFilter) {
        SingleClickStartEditMouseListener l = new SingleClickStartEditMouseListener(explorer, eventFilter);
        explorer.addListener((Object)l);
        return l;
    }

    public SingleClickStartEditMouseListener(GraphExplorer explorer, IFilter eventFilter) {
        if (explorer == null) {
            throw new NullPointerException("null explorer");
        }
        this.explorer = explorer;
        this.eventFilter = eventFilter;
        this.tree = (Tree)explorer.getControl();
        this.columns = explorer.getColumns();
    }

    public void mouseDown(MouseEvent e) {
        if (this.eventFilter != null && !this.eventFilter.select((Object)e)) {
            return;
        }
        Point point = new Point(e.x, e.y);
        TreeItem item = this.tree.getItem(point);
        if (item == null) {
            return;
        }
        NodeContext ctx = (NodeContext)item.getData();
        if (ctx == null) {
            return;
        }
        int i = 0;
        while (i < this.tree.getColumnCount() && i < this.columns.length) {
            if (item.getBounds(i).contains(point)) {
                this.explorer.startEditing(ctx, this.columns[i].getKey());
            }
            ++i;
        }
    }
}

