/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.Activator;
import org.simantics.browsing.ui.swt.ModelledControl;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.layer0.Layer0;

public class ModelledWikiEditorComposite
implements ModelledControl {
    private final Resource configuration;
    private TrackedText text;

    public ModelledWikiEditorComposite(Resource configuration) {
        this.configuration = configuration;
    }

    @Override
    public Control create(Composite parent, IWorkbenchSite site, ISessionContext context, WidgetSupport support) throws DatabaseException {
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite body = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).equalWidth(false).numColumns(3).applyTo(body);
        body.setBackground(Display.getCurrent().getSystemColor(1));
        Button header = new Button(body, 0);
        header.setImage(resourceManager.createImage(Activator.HEADING1_ICON));
        header.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String content = ModelledWikiEditorComposite.this.text.getText();
                int caretPos = ModelledWikiEditorComposite.this.text.getCaretPosition();
                String begin = content.substring(0, caretPos);
                String end = content.substring(caretPos, content.length());
                ModelledWikiEditorComposite.this.text.setTextWithoutNotify(String.valueOf(begin) + "\n=Header=\n" + end);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button bold = new Button(body, 0);
        bold.setImage(resourceManager.createImage(Activator.BOLD_ICON));
        bold.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String content = ModelledWikiEditorComposite.this.text.getText();
                Point p = ModelledWikiEditorComposite.this.text.getWidget().getSelection();
                String begin = content.substring(0, p.x);
                String mid = content.substring(p.x, p.y);
                String end = content.substring(p.y, content.length());
                ModelledWikiEditorComposite.this.text.setTextWithoutNotify(String.valueOf(begin) + "'''" + mid + "'''" + end);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button bullets = new Button(body, 0);
        bullets.setImage(resourceManager.createImage(Activator.BULLETS_ICON));
        bullets.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String content = ModelledWikiEditorComposite.this.text.getText();
                int caretPos = ModelledWikiEditorComposite.this.text.getCaretPosition();
                String begin = content.substring(0, caretPos);
                String end = content.substring(caretPos, content.length());
                ModelledWikiEditorComposite.this.text.setTextWithoutNotify(String.valueOf(begin) + "\n*List1\n*List2\n*List3\n" + end);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.text = new TrackedText(body, support, 0x800802);
        this.text.setMoveCaretAfterEdit(false);
        this.text.setTextFactory(new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasDescription", ""));
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.text.getWidget());
        this.text.addModifyListener(new TextModifyListenerImpl<Resource>(){

            @Override
            public void applyText(WriteGraph graph, Resource source, String newText) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                graph.claimLiteral(source, L0.HasDescription, (Object)newText);
            }
        });
        return body;
    }
}

