/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.lobobrowser.html.renderer.RBlock;
import org.simantics.browsing.ui.swt.Activator;
import org.simantics.browsing.ui.swt.ModelledControl;
import org.simantics.browsing.ui.swt.widgets.ResourceVariableFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.WikiBrowser;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.simantics.wiki.ui.editor.IExportable;
import org.simantics.wiki.ui.editor.WikiExportPDFAction;

public class ModelledWikiBrowserComposite
implements ModelledControl,
IExportable {
    private final Resource configuration;
    private WikiBrowser browser;

    public ModelledWikiBrowserComposite(Resource configuration) {
        this.configuration = configuration;
    }

    @Override
    public Control create(Composite parent, IWorkbenchSite site, ISessionContext context, final WidgetSupport support) throws DatabaseException {
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite body = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).equalWidth(false).numColumns(2).applyTo(body);
        body.setBackground(Display.getCurrent().getSystemColor(1));
        Button export = new Button(body, 0);
        export.setImage(resourceManager.createImage(Activator.PDF_ICON));
        export.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new WikiExportPDFAction((IExportable)ModelledWikiBrowserComposite.this).run();
            }
        });
        Button edit = new Button(body, 0);
        edit.setImage(resourceManager.createImage(Activator.EDIT_ICON));
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String editorId = "org.simantics.wiki.ui.editor";
                try {
                    Object input = support.getInput();
                    if (input instanceof Resource) {
                        WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new ResourceEditorInput(editorId, (Resource)input));
                    }
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Composite page = new Composite(body, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).equalWidth(false).numColumns(1).applyTo(page);
        page.setBackground(Display.getCurrent().getSystemColor(1));
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)page);
        this.browser = new WikiBrowser(page, support, 2048);
        this.browser.setTextFactory(new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasDescription", ""));
        this.browser.setVariableFactory(new ResourceVariableFactory());
        if (!this.browser.isDisposed()) {
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.browser.getWidget());
        }
        return body;
    }

    public void export(Document document, PdfWriter writer) throws DocumentException {
        PdfContentByte cb = writer.getDirectContent();
        int marginLeft = 20;
        int marginRight = 20;
        int marginTop = 10;
        int marginBottom = 45;
        int contentWidth = (int)PageSize.A4.getWidth() - marginLeft - marginRight;
        int contentHeight = (int)PageSize.A4.getHeight() - marginTop - marginBottom;
        ((RBlock)this.browser.getWidget().getPanel().getBlockRenderable()).layout(contentWidth, contentHeight, false, true, 0, 0, false);
        Rectangle bounds = ((RBlock)this.browser.getWidget().getPanel().getBlockRenderable()).getBounds();
        org.eclipse.swt.graphics.Rectangle browserBounds = this.browser.getWidget().getBounds();
        this.browser.getWidget().setBounds(0, 0, contentWidth, contentHeight);
        this.browser.getWidget().getPanel().getBlockRenderable().relayout();
        PdfTemplate template = null;
        int page = 0;
        while ((double)page < Math.floor((double)((float)bounds.height / (float)contentHeight) + 0.99)) {
            template = cb.createTemplate(PageSize.A4.getWidth(), PageSize.A4.getHeight());
            Graphics2D g2d = template.createGraphics(PageSize.A4.getWidth(), PageSize.A4.getHeight());
            g2d.translate(marginLeft, marginTop);
            g2d.setClip(0, 0, contentWidth, contentHeight);
            this.browser.getWidget().getPanel().getBlockRenderable().setOrigin(0, -page * contentHeight);
            this.browser.getWidget().getPanel().getBlockRenderable().paintTranslated((Graphics)g2d);
            g2d.dispose();
            cb.addTemplate(template, 0.0f, 0.0f);
            document.newPage();
            ++page;
        }
        this.browser.getWidget().setBounds(browserBounds);
    }
}

