/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.IProgressConstants;
import org.simantics.DatabaseJob;
import org.simantics.browsing.ui.swt.GraphExplorerImplBase;

class ImageLoaderJob
extends DatabaseJob {
    private GraphExplorerImplBase ge;
    private AtomicBoolean isScheduled = new AtomicBoolean();

    public ImageLoaderJob(GraphExplorerImplBase ge) {
        super("Image Loader");
        this.ge = ge;
        this.setSystem(true);
        this.setUser(false);
        this.setPriority(50);
        this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
    }

    public boolean scheduleIfNecessary(long delay) {
        if (this.isScheduled.compareAndSet(false, true)) {
            this.schedule(delay);
            return true;
        }
        return false;
    }

    public boolean shouldRun() {
        return this.ge != null;
    }

    public boolean shouldSchedule() {
        return this.ge != null;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.isScheduled.set(false);
            GraphExplorerImplBase ge = this.ge;
            IStatus iStatus = ge != null ? ge.setPendingImages(monitor) : Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public void dispose() {
        this.ge = null;
    }
}

