/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.utils.ui.AdaptionUtils;

public class GraphExplorerMouseAdapter
extends MouseAdapter {
    protected GraphExplorer ge;

    public GraphExplorerMouseAdapter(GraphExplorer ge) {
        this.ge = ge;
    }

    protected ISelection getClickedContext(MouseEvent e) {
        Point point;
        Tree tree = (Tree)e.getSource();
        TreeItem item = tree.getItem(point = new Point(e.x, e.y));
        if (item == null) {
            return null;
        }
        Object data = item.getData();
        NodeContext context = (NodeContext)AdaptionUtils.adaptToSingle((Object)data, NodeContext.class);
        if (context == null) {
            return null;
        }
        ISelectionProvider sp = (ISelectionProvider)this.ge.getAdapter(ISelectionProvider.class);
        ISelection selection = sp.getSelection();
        NodeContext selectionContext = (NodeContext)AdaptionUtils.adaptToSingle((Object)selection, NodeContext.class);
        if (!context.equals(selectionContext)) {
            return new StructuredSelection((Object)context);
        }
        return selection;
    }

    public void mouseDoubleClick(MouseEvent e) {
        ISelection context = this.getClickedContext(e);
        if (context == null) {
            return;
        }
        Tree tree = (Tree)e.getSource();
        this.handleContextDoubleClick(tree, context);
    }

    protected void handleContextDoubleClick(Tree tree, ISelection selection) {
    }
}

