/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.processors.AbstractPrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.processors.ProcessorLifecycle;
import org.simantics.browsing.ui.common.processors.ShowMaxChildrenProcessor;

public class DefaultShowMaxChildrenProcessor
extends AbstractPrimitiveQueryProcessor<Integer>
implements ShowMaxChildrenProcessor,
ProcessorLifecycle {
    private final Integer MAX_INT = Integer.MAX_VALUE;
    private final TObjectIntHashMap<NodeContext> showMaxChildren = new TObjectIntHashMap();
    private final THashMap<NodeContext, PrimitiveQueryUpdater> showMaxChildrenQueries = new THashMap();

    public Object getIdentifier() {
        return BuiltinKeys.SHOW_MAX_CHILDREN;
    }

    public String toString() {
        return "ShowMaxChildrenProcessor";
    }

    public Integer query(PrimitiveQueryUpdater updater, NodeContext context, NodeContext.PrimitiveQueryKey<Integer> key) {
        int maxChildren = this.showMaxChildren.get((Object)context);
        this.showMaxChildrenQueries.put((Object)context, (Object)updater);
        if (maxChildren == 0) {
            return null;
        }
        return maxChildren;
    }

    public boolean setShowMaxChildren(NodeContext context, int maxChildren) {
        return this._setShowMaxChildren(context, maxChildren);
    }

    public boolean replaceShowMaxChildren(NodeContext context, int maxChildren) {
        return this.nodeStatusChanged(context, maxChildren);
    }

    private boolean _setShowMaxChildren(NodeContext context, int maxChildren) {
        if (maxChildren > 0) {
            return this.showMaxChildren.put((Object)context, maxChildren) != maxChildren;
        }
        return this.showMaxChildren.remove((Object)context) != 0;
    }

    protected boolean nodeStatusChanged(NodeContext context, int maxChildren) {
        boolean result = this._setShowMaxChildren(context, maxChildren);
        PrimitiveQueryUpdater updater = (PrimitiveQueryUpdater)this.showMaxChildrenQueries.get((Object)context);
        if (updater != null) {
            Integer newValue = null;
            if (maxChildren > 0) {
                newValue = maxChildren != Integer.MAX_VALUE ? Integer.valueOf(maxChildren) : this.MAX_INT;
            }
            updater.scheduleReplace(context, BuiltinKeys.SHOW_MAX_CHILDREN, newValue);
        }
        return result;
    }

    public void attached(GraphExplorer explorer) {
    }

    public void detached(GraphExplorer explorer) {
        this.clear();
    }

    public void clear() {
        this.showMaxChildren.clear();
        this.showMaxChildrenQueries.clear();
    }
}

