/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.request.Read;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.utils.datastructures.Function;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class DefaultKeyListener
extends KeyAdapter {
    private final ISessionContextProvider contextProvider;
    private final GraphExplorer explorer;
    private final Function<String[]> editingColumnResolver;

    public DefaultKeyListener(ISessionContextProvider contextProvider, GraphExplorer explorer, Function<String[]> editingColumnResolver) {
        assert (contextProvider != null);
        assert (explorer != null);
        assert (editingColumnResolver != null);
        this.contextProvider = contextProvider;
        this.explorer = explorer;
        this.editingColumnResolver = editingColumnResolver;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            if (this.explorer.isDisposed()) {
                return;
            }
            ISessionContext sessionContext = this.contextProvider.getSessionContext();
            if (sessionContext == null) {
                return;
            }
            IPostSelectionProvider selectionProvider = (IPostSelectionProvider)this.explorer.getAdapter(IPostSelectionProvider.class);
            ISelection input = selectionProvider.getSelection();
            if (input.isEmpty()) {
                return;
            }
            String perspectiveId = WorkbenchUtils.getCurrentPerspectiveId();
            Control control = (Control)this.explorer.getControl();
            Shell shell = control.getShell();
            sessionContext.getSession().asyncRequest((Read)new ChooseActionRequest(shell, (Object)this.explorer, (Object)input, perspectiveId));
        } else if (e.keyCode == 0x100000B) {
            IPostSelectionProvider selectionProvider = (IPostSelectionProvider)this.explorer.getAdapter(IPostSelectionProvider.class);
            NodeContext context = (NodeContext)ISelectionUtils.filterSingleSelection((Object)selectionProvider.getSelection(), NodeContext.class);
            if (context == null) {
                return;
            }
            String[] stringArray = (String[])this.editingColumnResolver.execute(new Object[]{context});
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String column = stringArray[n2];
                String error = this.explorer.startEditing(context, column);
                if (error == null) {
                    return;
                }
                ++n2;
            }
            return;
        }
    }
}

