/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.processors.AbstractPrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.processors.IsExpandedProcessor;
import org.simantics.browsing.ui.common.processors.ProcessorLifecycle;

public class DefaultIsExpandedProcessor
extends AbstractPrimitiveQueryProcessor<Boolean>
implements IsExpandedProcessor,
ProcessorLifecycle {
    private final HashSet<NodeContext> expanded = new HashSet();
    private final HashMap<NodeContext, PrimitiveQueryUpdater> expandedQueries = new HashMap();
    private Tree tree;
    Listener treeListener = new Listener(){

        public void handleEvent(Event event) {
            NodeContext context = (NodeContext)event.item.getData();
            switch (event.type) {
                case 17: {
                    DefaultIsExpandedProcessor.this.nodeStatusChanged(context, true);
                    break;
                }
                case 18: {
                    DefaultIsExpandedProcessor.this.nodeStatusChanged(context, false);
                }
            }
        }
    };

    public Object getIdentifier() {
        return BuiltinKeys.IS_EXPANDED;
    }

    public String toString() {
        return "IsExpandedProcessor";
    }

    public Boolean query(PrimitiveQueryUpdater updater, NodeContext context, NodeContext.PrimitiveQueryKey<Boolean> key) {
        boolean isExpanded = this.expanded.contains(context);
        this.expandedQueries.put(context, updater);
        return isExpanded;
    }

    public Collection<NodeContext> getExpanded() {
        return new HashSet<NodeContext>(this.expanded);
    }

    public boolean getExpanded(NodeContext context) {
        return this.expanded.contains(context);
    }

    public boolean setExpanded(NodeContext context, boolean expanded) {
        return this._setExpanded(context, expanded);
    }

    public boolean replaceExpanded(NodeContext context, boolean expanded) {
        return this.nodeStatusChanged(context, expanded);
    }

    private boolean _setExpanded(NodeContext context, boolean expanded) {
        if (expanded) {
            return this.expanded.add(context);
        }
        return this.expanded.remove(context);
    }

    protected boolean nodeStatusChanged(NodeContext context, boolean expanded) {
        boolean result = this._setExpanded(context, expanded);
        PrimitiveQueryUpdater updater = this.expandedQueries.get(context);
        if (updater != null) {
            updater.scheduleReplace(context, BuiltinKeys.IS_EXPANDED, (Object)expanded);
        }
        return result;
    }

    public void attached(GraphExplorer explorer) {
        Object control = explorer.getControl();
        if (control instanceof Tree) {
            this.tree = (Tree)control;
            this.tree.addListener(17, this.treeListener);
            this.tree.addListener(18, this.treeListener);
        } else {
            System.out.println("WARNING: " + ((Object)((Object)this)).getClass().getSimpleName() + " attached to unsupported control: " + control);
        }
    }

    public void clear() {
        this.expanded.clear();
        this.expandedQueries.clear();
    }

    public void detached(GraphExplorer explorer) {
        this.clear();
        if (this.tree != null) {
            this.tree.removeListener(17, this.treeListener);
            this.tree.removeListener(18, this.treeListener);
            this.tree = null;
        }
    }
}

