/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBoxCellEditor2
extends CellEditor {
    private static final int KEY_INPUT_DELAY = 500;
    private String[] items;
    int selection;
    Combo comboBox;
    private static final int defaultStyle = 0;

    public ComboBoxCellEditor2() {
        this.setStyle(0);
    }

    public ComboBoxCellEditor2(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public ComboBoxCellEditor2(Composite parent, String[] items, int style) {
        super(parent, style);
        this.setItems(items);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new Combo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.populateComboBoxItems();
        if ((this.getStyle() | 8) > 0) {
            this.comboBox.addKeyListener((KeyListener)new AutoCompleteAdapter(this.comboBox));
        }
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ComboBoxCellEditor2.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ComboBoxCellEditor2.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                ComboBoxCellEditor2.this.selection = ComboBoxCellEditor2.this.comboBox.getSelectionIndex();
                ComboBoxCellEditor2.this.applyEditorValueAndDeactivate();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxCellEditor2.this.focusLost();
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        return new Integer(this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.comboBox != null && value instanceof Integer ? 1 : 0) != 0);
        this.selection = (Integer)value;
        this.comboBox.select(this.selection);
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            if (this.items.length > 0 && this.selection >= 0 && this.selection < this.items.length) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    private class AutoCompleteAdapter
    extends KeyAdapter {
        private Combo combo;
        private String matcher = "";
        private int prevEvent = 0;
        private int prevIndex = -1;
        private int toBeSelected = -1;
        protected Pattern alphaNum;

        public AutoCompleteAdapter(Combo combo) {
            this.combo = combo;
            this.alphaNum = Pattern.compile("\\p{Alnum}");
        }

        public void keyPressed(KeyEvent e) {
            if (this.combo.isDisposed()) {
                return;
            }
            if (e.keyCode == 13 && this.prevIndex != -1) {
                this.combo.select(this.toBeSelected);
            }
            if (!this.alphaNum.matcher(Character.toString(e.character)).matches()) {
                return;
            }
            if (e.time - this.prevEvent > 500) {
                this.matcher = "";
            }
            this.prevEvent = e.time;
            this.matcher = this.matcher = String.valueOf(this.matcher) + Character.toString(e.character);
            int index = this.findMatching();
            if (index != -1) {
                this.combo.setText(this.combo.getItem(index));
                this.toBeSelected = index;
            }
            this.prevIndex = index;
            e.doit = false;
        }

        public int findMatching() {
            int index = -1;
            if (this.prevIndex == -1) {
                index = this.getMatchingIndex(this.matcher);
            } else {
                index = this.getMatchingIndex(this.matcher, this.prevIndex);
                if (index == -1) {
                    index = this.getMatchingIndex(this.matcher);
                }
                if (index == -1) {
                    this.matcher = this.matcher.substring(this.matcher.length() - 1);
                    index = this.getMatchingIndex(this.matcher, this.prevIndex);
                    if (index == -1) {
                        index = this.getMatchingIndex(this.matcher);
                    }
                }
            }
            return index;
        }

        public int getMatchingIndex(String prefix) {
            int i = 0;
            while (i < this.combo.getItemCount()) {
                if (this.combo.getItem(i).toLowerCase().trim().startsWith(this.matcher)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getMatchingIndex(String prefix, int firstIndex) {
            int i = firstIndex + 1;
            while (i < this.combo.getItemCount()) {
                if (this.combo.getItem(i).toLowerCase().trim().startsWith(this.matcher)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

