/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultiLineInputDialog
extends InputDialog {
    private String[] values;
    private IInputValidator[] validators;
    private String[] messages;
    private Text[] errorMessageTexts;
    private Text[] texts;
    private int count;
    private static String INDEX_KEY = "index";

    public MultiLineInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, Object ... moreLines) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        if (moreLines.length % 3 != 0) {
            throw new IllegalArgumentException("bad argument count");
        }
        this.count = moreLines.length / 3;
        this.values = new String[this.count];
        this.messages = new String[this.count];
        this.validators = new IInputValidator[this.count];
        this.errorMessageTexts = new Text[this.count];
        this.texts = new Text[this.count];
        int i = 0;
        while (i < this.count) {
            this.values[i] = (String)moreLines[i * 3 + 1];
            this.messages[i] = (String)moreLines[i * 3];
            this.validators[i] = (IInputValidator)moreLines[i * 3 + 2];
            ++i;
        }
    }

    public String getValue(int index) {
        if (index == 0) {
            return this.getValue();
        }
        return this.values[index - 1];
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ModifyListener textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MultiLineInputDialog.this.getOkButton() == null) {
                    return;
                }
                int index = (Integer)e.widget.getData(INDEX_KEY);
                Text text = (Text)e.widget;
                IInputValidator validator = MultiLineInputDialog.this.validators[index];
                String errorMessage = null;
                if (validator != null) {
                    errorMessage = validator.isValid(text.getText());
                }
                MultiLineInputDialog.this.errorMessageTexts[index].setText(errorMessage == null ? "" : errorMessage);
                MultiLineInputDialog.this.errorMessageTexts[index].getParent().update();
                boolean ok = MultiLineInputDialog.this.getValidator().isValid(MultiLineInputDialog.this.getText().getText()) == null;
                int i = 0;
                while (i < MultiLineInputDialog.this.count) {
                    ok &= MultiLineInputDialog.this.errorMessageTexts[i].getText().equals("");
                    ++i;
                }
                MultiLineInputDialog.this.getOkButton().setEnabled(ok);
            }
        };
        int i = 0;
        while (i < this.count) {
            String message = this.messages[i];
            if (message != null) {
                Label label = new Label(composite, 64);
                label.setText(message);
                GridData data = new GridData(1796);
                data.widthHint = this.convertHorizontalDLUsToPixels(300);
                label.setLayoutData((Object)data);
                label.setFont(parent.getFont());
            }
            this.texts[i] = new Text(composite, 2052);
            this.texts[i].setLayoutData((Object)new GridData(768));
            this.texts[i].setData(INDEX_KEY, (Object)new Integer(i));
            this.texts[i].addModifyListener(textModifyListener);
            this.errorMessageTexts[i] = new Text(composite, 8);
            this.errorMessageTexts[i].setLayoutData((Object)new GridData(768));
            this.errorMessageTexts[i].setBackground(this.errorMessageTexts[i].getDisplay().getSystemColor(22));
            this.errorMessageTexts[i].setForeground(this.errorMessageTexts[i].getDisplay().getSystemColor(3));
            ++i;
        }
        i = 0;
        while (i < this.count) {
            this.texts[i].setText(this.values[i]);
            ++i;
        }
        ArrayList<Text> tabs = new ArrayList<Text>();
        tabs.add(this.getText());
        Text[] textArray = this.texts;
        int n = this.texts.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            tabs.add(t);
            ++n2;
        }
        composite.setTabList(tabs.toArray(new Control[0]));
        MultiLineInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        boolean ok = this.getValidator().isValid(this.getText().getText()) == null;
        int i = 0;
        while (i < this.count) {
            String error;
            String txt = this.texts[i].getText();
            if (txt == null) {
                txt = "";
            }
            boolean valid = (error = this.validators[i].isValid(txt)) == null;
            ok &= valid;
            ++i;
        }
        this.getOkButton().setEnabled(ok);
    }

    protected boolean allFieldsValid() {
        if (this.getValidator().isValid(this.getText().getText()) != null) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            boolean valid;
            if (this.texts[i] == null) {
                return true;
            }
            String txt = this.texts[i].getText();
            if (txt == null) {
                txt = "";
            }
            boolean bl = valid = this.validators[i].isValid(txt) == null;
            if (!valid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
        if (this.getOkButton() == null) {
            return;
        }
        this.getOkButton().setEnabled(this.allFieldsValid());
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            int i = 0;
            while (i < this.values.length) {
                this.values[i] = this.texts[i].getText();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.values.length) {
                this.values[i] = null;
                ++i;
            }
        }
        super.buttonPressed(buttonId);
    }
}

