/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.simantics.utils.ui.color.ColorGradient;

public class ColorGradientCanvas
extends Canvas {
    ColorGradient gradient;
    int style;

    public ColorGradientCanvas(Composite parent, int style) {
        super(parent, 2048);
        this.style = style & 0x300;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle clip = gc.getClipping();
                if (ColorGradientCanvas.this.gradient != null) {
                    Image image = ColorGradientCanvas.this.gradient.getGradientImage(clip.width, clip.height, ColorGradientCanvas.this.style);
                    gc.drawImage(image, 0, 0);
                    image.dispose();
                } else {
                    gc.setBackground(Display.getCurrent().getSystemColor(1));
                    gc.fillRectangle(clip);
                }
            }
        });
    }

    public void setGradient(ColorGradient gradient) {
        this.gradient = gradient;
        this.redraw();
    }
}

