/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.color.ColorGradient;
import org.simantics.utils.ui.color.ColorGradientCanvas;
import org.simantics.utils.ui.color.ColorValue;

public class ColorComposite
extends Composite {
    private Color color = new Color(255, 255, 255);
    private ColorGradient rGradient;
    private ColorGradient gGradient;
    private ColorGradient bGradient;
    private ColorGradient colorGradient;
    Text rText;
    Text gText;
    Text bText;
    ColorGradientCanvas rCanvas;
    ColorGradientCanvas gCanvas;
    ColorGradientCanvas bCanvas;
    ColorGradientCanvas colorCanvas;

    public ColorComposite(Composite parent, int style) {
        super(parent, style);
        this.updateGradients();
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.colorCanvas = new ColorGradientCanvas(this, 2304);
        GridData colorCanvasData = new GridData();
        colorCanvasData.horizontalSpan = 3;
        colorCanvasData.heightHint = 32;
        colorCanvasData.widthHint = 600;
        colorCanvasData.grabExcessHorizontalSpace = true;
        this.colorCanvas.setLayoutData(colorCanvasData);
        GridData labelData = new GridData();
        labelData.widthHint = 30;
        GridData gradientData = new GridData();
        gradientData.grabExcessHorizontalSpace = true;
        gradientData.heightHint = 16;
        gradientData.widthHint = 500;
        GridData textData = new GridData();
        textData.widthHint = 30;
        Label rLabel = new Label((Composite)this, 0);
        rLabel.setText("Red");
        rLabel.setLayoutData((Object)labelData);
        this.rCanvas = new ColorGradientCanvas(this, 2304);
        this.rCanvas.setLayoutData(gradientData);
        this.rText = new Text((Composite)this, 2048);
        this.rText.setLayoutData((Object)textData);
        this.rCanvas.addMouseListener(new ColorSelectListener(this.rCanvas){

            @Override
            void setValue(int value) {
                Color newColor = new Color(value, ColorComposite.this.color.getG(), ColorComposite.this.color.getB());
                ColorComposite.this.updateColor(newColor);
            }
        });
        Label gLabel = new Label((Composite)this, 0);
        gLabel.setText("Green");
        gLabel.setLayoutData((Object)labelData);
        this.gCanvas = new ColorGradientCanvas(this, 2304);
        this.gCanvas.setLayoutData(gradientData);
        this.gText = new Text((Composite)this, 2048);
        this.gText.setLayoutData((Object)textData);
        this.gCanvas.addMouseListener(new ColorSelectListener(this.gCanvas){

            @Override
            void setValue(int value) {
                Color newColor = new Color(ColorComposite.this.color.getR(), value, ColorComposite.this.color.getB());
                ColorComposite.this.updateColor(newColor);
            }
        });
        Label bLabel = new Label((Composite)this, 0);
        bLabel.setText("Blue");
        bLabel.setLayoutData((Object)labelData);
        this.bCanvas = new ColorGradientCanvas(this, 2304);
        this.bCanvas.setLayoutData(gradientData);
        this.bText = new Text((Composite)this, 2048);
        this.bText.setLayoutData((Object)textData);
        this.bCanvas.addMouseListener(new ColorSelectListener(this.bCanvas){

            @Override
            void setValue(int value) {
                Color newColor = new Color(ColorComposite.this.color.getR(), ColorComposite.this.color.getG(), value);
                ColorComposite.this.updateColor(newColor);
            }
        });
        this.updateWidgets();
    }

    private void updateColor(Color color) {
        this.color = color;
        this.updateWidgets();
    }

    private void updateGradients() {
        this.rGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(0, this.color.getG(), this.color.getB()), 0.0), new ColorValue(new Color(255, this.color.getG(), this.color.getB()), 1.0)});
        this.gGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(this.color.getR(), 0, this.color.getB()), 0.0), new ColorValue(new Color(this.color.getR(), 255, this.color.getB()), 1.0)});
        this.bGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(this.color.getR(), this.color.getG(), 0), 0.0), new ColorValue(new Color(this.color.getR(), this.color.getG(), 255), 1.0)});
        this.colorGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(this.color.getR(), this.color.getG(), this.color.getB()), 0.0)});
    }

    private void updateWidgets() {
        this.updateGradients();
        this.rCanvas.setGradient(this.rGradient);
        this.gCanvas.setGradient(this.gGradient);
        this.bCanvas.setGradient(this.bGradient);
        this.colorCanvas.setGradient(this.colorGradient);
        this.rText.setText(Integer.toString(this.color.getR()));
        this.gText.setText(Integer.toString(this.color.getG()));
        this.bText.setText(Integer.toString(this.color.getB()));
    }

    private abstract class ColorSelectListener
    implements MouseListener {
        private Canvas canvas;

        public ColorSelectListener(Canvas canvas) {
            this.canvas = canvas;
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            Rectangle r = this.canvas.getBounds();
            double d = (double)e.x / (double)r.width;
            int value = (int)(d * 255.0);
            if (value < 0) {
                value = 0;
            }
            if (value > 255) {
                value = 255;
            }
            this.setValue(value);
        }

        public void mouseUp(MouseEvent e) {
        }

        abstract void setValue(int var1);
    }
}

