/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.awt;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.simantics.utils.ui.awt.AwtEnvironment;
import org.simantics.utils.ui.awt.AwtFocusHandler;
import org.simantics.utils.ui.awt.CleanResizeListener;
import org.simantics.utils.ui.awt.EmbeddedChildFocusTraversalPolicy;
import org.simantics.utils.ui.awt.SwtFocusHandler;

public abstract class EmbeddedSwingComposite
extends Composite {
    private org.eclipse.swt.graphics.Font currentSystemFont;
    private AwtContext awtContext;
    private AwtFocusHandler awtHandler;
    private Listener settingsListener = new Listener(){

        public void handleEvent(Event event) {
            EmbeddedSwingComposite.this.handleSettingsChange();
        }
    };
    private final Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            if (!$assertionsDisabled && EmbeddedSwingComposite.this.awtHandler == null) {
                throw new AssertionError();
            }
            EmbeddedSwingComposite.this.awtHandler.postHidePopups();
        }
    };

    public EmbeddedSwingComposite(Composite parent, int style) {
        super(parent, style | 0x1000000 | 0x40000);
        this.getDisplay().addListener(39, this.settingsListener);
        this.setLayout((Layout)new FillLayout());
        this.currentSystemFont = this.getFont();
    }

    public void populate() {
        this.checkWidget();
        this.createFrame();
        this.scheduleComponentCreation();
    }

    protected abstract JComponent createSwingComponent();

    protected RootPaneContainer addRootPaneContainer(Frame frame) {
        assert (EventQueue.isDispatchThread());
        assert (frame != null);
        JApplet applet = new JApplet();
        applet.setFocusCycleRoot(false);
        frame.add(applet);
        return applet;
    }

    protected void updateAwtFont(Font newFont) {
    }

    public Frame getFrame() {
        if (this.getDisplay() == null || this.isDisposed()) {
            SWT.error((int)24);
        }
        return this.awtContext != null ? this.awtContext.getFrame() : null;
    }

    private void createFrame() {
        assert (Display.getCurrent() != null);
        AwtEnvironment.getInstance(this.getDisplay());
        if (this.awtContext != null) {
            final Frame oldFrame = this.awtContext.getFrame();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oldFrame.dispose();
                }
            });
        }
        Frame frame = SWT_AWT.new_Frame((Composite)this);
        this.awtContext = new AwtContext(frame);
        this.createFocusHandlers();
        this.addControlListener((ControlListener)new CleanResizeListener());
    }

    private void createFocusHandlers() {
        assert (this.awtContext != null);
        assert (Display.getCurrent() != null);
        Frame frame = this.awtContext.getFrame();
        this.awtHandler = new AwtFocusHandler(frame);
        SwtFocusHandler swtHandler = new SwtFocusHandler(this);
        this.awtHandler.setSwtHandler(swtHandler);
        swtHandler.setAwtHandler(this.awtHandler);
        this.getDisplay().addFilter(22, this.menuListener);
        EmbeddedChildFocusTraversalPolicy policy = new EmbeddedChildFocusTraversalPolicy(this.awtHandler);
        frame.setFocusTraversalPolicy(policy);
    }

    private void scheduleComponentCreation() {
        assert (this.awtContext != null);
        final AwtContext currentContext = this.awtContext;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RootPaneContainer container = EmbeddedSwingComposite.this.addRootPaneContainer(currentContext.getFrame());
                JComponent swingComponent = EmbeddedSwingComposite.this.createSwingComponent();
                currentContext.setSwingComponent(swingComponent);
                container.getRootPane().getContentPane().add(swingComponent);
                EmbeddedSwingComposite.this.setComponentFont();
            }
        });
    }

    private void setComponentFont() {
        JComponent swingComponent;
        assert (this.currentSystemFont != null);
        assert (EventQueue.isDispatchThread());
        JComponent jComponent = swingComponent = this.awtContext != null ? this.awtContext.getSwingComponent() : null;
        if (swingComponent != null && !this.currentSystemFont.getDevice().isDisposed()) {
            FontData fontData = this.currentSystemFont.getFontData()[0];
            int resolution = Toolkit.getDefaultToolkit().getScreenResolution();
            int awtFontSize = (int)Math.round((double)fontData.getHeight() * (double)resolution / 72.0);
            Font awtFont = new Font(fontData.getName(), fontData.getStyle(), awtFontSize);
            this.updateLookAndFeel(awtFont);
            this.updateAwtFont(awtFont);
            Container contentPane = swingComponent.getRootPane().getContentPane();
            SwingUtilities.updateComponentTreeUI(contentPane);
        }
    }

    private void updateLookAndFeel(Font awtFont) {
        assert (awtFont != null);
        assert (EventQueue.isDispatchThread());
        FontUIResource fontResource = new FontUIResource(awtFont);
        UIManager.put("Button.font", fontResource);
        UIManager.put("CheckBox.font", fontResource);
        UIManager.put("ComboBox.font", fontResource);
        UIManager.put("EditorPane.font", fontResource);
        UIManager.put("Label.font", fontResource);
        UIManager.put("List.font", fontResource);
        UIManager.put("Panel.font", fontResource);
        UIManager.put("ProgressBar.font", fontResource);
        UIManager.put("RadioButton.font", fontResource);
        UIManager.put("ScrollPane.font", fontResource);
        UIManager.put("TabbedPane.font", fontResource);
        UIManager.put("Table.font", fontResource);
        UIManager.put("TableHeader.font", fontResource);
        UIManager.put("TextField.font", fontResource);
        UIManager.put("TextPane.font", fontResource);
        UIManager.put("TitledBorder.font", fontResource);
        UIManager.put("ToggleButton.font", fontResource);
        UIManager.put("TreeFont.font", fontResource);
        UIManager.put("ViewportFont.font", fontResource);
    }

    private void handleSettingsChange() {
        org.eclipse.swt.graphics.Font newFont = this.getDisplay().getSystemFont();
        if (!newFont.equals((Object)this.currentSystemFont)) {
            this.currentSystemFont = newFont;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EmbeddedSwingComposite.this.setComponentFont();
                }
            });
        }
    }

    private boolean isFocusable() {
        if (this.awtContext == null) {
            return false;
        }
        JComponent swingComponent = this.awtContext.getSwingComponent();
        return swingComponent != null && swingComponent.isFocusable();
    }

    public boolean setFocus() {
        this.checkWidget();
        if (!this.isFocusable()) {
            return false;
        }
        return super.setFocus();
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (!this.isFocusable()) {
            return false;
        }
        return super.forceFocus();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getDisplay().removeListener(39, this.settingsListener);
            this.getDisplay().removeFilter(22, this.menuListener);
            super.dispose();
        }
    }

    private static class AwtContext {
        private Frame frame;
        private JComponent swingComponent;

        AwtContext(Frame frame) {
            assert (frame != null);
            this.frame = frame;
        }

        Frame getFrame() {
            return this.frame;
        }

        void setSwingComponent(JComponent swingComponent) {
            this.swingComponent = swingComponent;
        }

        JComponent getSwingComponent() {
            return this.swingComponent;
        }
    }
}

