/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.LayoutFocusTraversalPolicy;
import org.simantics.utils.ui.awt.AwtFocusHandler;

public class EmbeddedChildFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    private static final long serialVersionUID = -7708166698501335927L;
    private final AwtFocusHandler awtHandler;

    public EmbeddedChildFocusTraversalPolicy(AwtFocusHandler handler) {
        assert (handler != null);
        this.awtHandler = handler;
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        assert (container != null);
        assert (component != null);
        assert (this.awtHandler != null);
        assert (EventQueue.isDispatchThread());
        if (component.equals(this.getLastComponent(container))) {
            this.awtHandler.transferFocusNext();
            return null;
        }
        return super.getComponentAfter(container, component);
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        assert (container != null);
        assert (component != null);
        assert (this.awtHandler != null);
        assert (EventQueue.isDispatchThread());
        if (component.equals(this.getFirstComponent(container))) {
            this.awtHandler.transferFocusPrevious();
            return null;
        }
        return super.getComponentBefore(container, component);
    }

    @Override
    public Component getDefaultComponent(Container container) {
        assert (container != null);
        assert (this.awtHandler != null);
        assert (EventQueue.isDispatchThread());
        if (this.awtHandler.awtHasFocus()) {
            return super.getDefaultComponent(container);
        }
        return null;
    }

    public Component getCurrentComponent(Container container) {
        assert (container != null);
        assert (this.awtHandler != null);
        assert (EventQueue.isDispatchThread());
        Component currentAwtComponent = this.awtHandler.getCurrentComponent();
        if (currentAwtComponent != null && container.isAncestorOf(currentAwtComponent)) {
            return currentAwtComponent;
        }
        return this.getDefaultComponent(container);
    }
}

